/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.authorizers;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.model.Filters;
import io.undertow.predicate.Predicate;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.restheart.ConfigurationException;
import org.restheart.cache.Cache;
import org.restheart.cache.CacheFactory;
import org.restheart.cache.LoadingCache;
import org.restheart.exchange.Request;
import org.restheart.plugins.ConfigurablePlugin;
import org.restheart.plugins.InjectConfiguration;
import org.restheart.plugins.InjectMongoClient;
import org.restheart.plugins.InjectPluginsRegistry;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.Authorizer;
import org.restheart.security.BaseAclPermission;
import org.restheart.security.MongoPermissions;
import org.restheart.security.authorizers.MongoAclPermission;
import org.restheart.security.utils.MongoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="mongoAclAuthorizer", description="authorizes requests against acl stored in mongodb")
public class MongoAclAuthorizer
implements Authorizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoAclAuthorizer.class);
    public static final String X_FORWARDED_ACCOUNT_ID = "rhAuthenticator";
    public static final String X_FORWARDED_ROLE = "RESTHeart";
    public static final String ACL_COLLECTION_NAME = "acl";
    public static final String $UNAUTHENTICATED = "$unauthenticated";
    String aclDb;
    String aclCollection;
    private String rootRole = null;
    private boolean cacheEnabled = false;
    private Integer cacheSize = 1000;
    private Integer cacheTTL = 60000;
    private Cache.EXPIRE_POLICY cacheExpirePolicy = Cache.EXPIRE_POLICY.AFTER_WRITE;
    private LoadingCache<String, LinkedHashSet<MongoAclPermission>> acl = null;
    private MongoClient mclient;
    private PluginsRegistry registry;
    private static final BsonDocument PROJECTION = BsonDocument.parse((String)"{\"_id\":1,\"roles\":1,\"predicate\":1,\"writeFilter\":1,\"readFilter\":1,\"priority\":1,\"mongo\":1}");
    private static final BsonDocument SORT = BsonDocument.parse((String)"{\"priority\":-1,\"_id\":-1}");

    @InjectConfiguration
    public void initConfiguration(Map<String, Object> args) {
        this.aclDb = (String)ConfigurablePlugin.argValue(args, (String)"acl-db");
        this.aclCollection = (String)ConfigurablePlugin.argValue(args, (String)"acl-collection");
        this.rootRole = (String)ConfigurablePlugin.argValue(args, (String)"root-role");
        if (args != null && args.containsKey("cache-enabled")) {
            this.cacheEnabled = (Boolean)ConfigurablePlugin.argValue(args, (String)"cache-enabled");
            if (this.cacheEnabled) {
                this.cacheSize = (Integer)ConfigurablePlugin.argValue(args, (String)"cache-size");
                this.cacheTTL = (Integer)ConfigurablePlugin.argValue(args, (String)"cache-ttl");
                String _cacheExpirePolicy = (String)ConfigurablePlugin.argValue(args, (String)"cache-expire-policy");
                if (_cacheExpirePolicy != null) {
                    try {
                        this.cacheExpirePolicy = Cache.EXPIRE_POLICY.valueOf((String)_cacheExpirePolicy);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ConfigurationException("wrong configuration file format. cache-expire-policy valid values are " + Arrays.toString(Cache.EXPIRE_POLICY.values()));
                    }
                }
                this.acl = CacheFactory.createLocalLoadingCache((long)this.cacheSize.intValue(), (Cache.EXPIRE_POLICY)this.cacheExpirePolicy, (long)this.cacheTTL.intValue(), role -> this.findRolePermissions((String)role));
            }
        }
    }

    @InjectMongoClient
    public void initMongoClient(MongoClient mclient) {
        this.mclient = mclient;
        if (!this.checkAclCollection()) {
            LOGGER.error("ACL collection does not exist and could not be created");
        }
    }

    @InjectPluginsRegistry
    public void initRegistry(PluginsRegistry registry) {
        this.registry = registry;
    }

    public boolean isAllowed(Request<?> request) {
        if (request.isOptions()) {
            return true;
        }
        HttpServerExchange exchange = request.getExchange();
        if (this.rootRole != null && exchange.getSecurityContext() != null && exchange.getSecurityContext().getAuthenticatedAccount() != null && exchange.getSecurityContext().getAuthenticatedAccount().getRoles().contains(this.rootRole)) {
            LOGGER.debug("allow request for root user {}", (Object)exchange.getSecurityContext().getAuthenticatedAccount().getPrincipal().getName());
            HashSet roles = Sets.newHashSet();
            roles.add(this.rootRole);
            exchange.putAttachment(BaseAclPermission.MATCHING_ACL_PERMISSION, (Object)new MongoAclPermission((BsonValue)new BsonObjectId(), "path-prefix('/')", roles, Integer.MAX_VALUE, new BsonDocument("mongo", (BsonValue)MongoPermissions.ALLOW_ALL_MONGO_PERMISSIONS.asBson())));
            return true;
        }
        if (exchange.getAttachment(Predicate.PREDICATE_CONTEXT) == null) {
            exchange.putAttachment(Predicate.PREDICATE_CONTEXT, new TreeMap());
        }
        exchange.setRelativePath(exchange.getRequestPath());
        ArrayList permissions = new ArrayList();
        if (LOGGER.isDebugEnabled()) {
            this.roles(exchange).forEachOrdered(role -> {
                ArrayList matched = Lists.newArrayListWithCapacity((int)1);
                this.rolePermissions((String)role).stream().anyMatch(permission -> {
                    String marker;
                    boolean resolved = permission.allow(request);
                    if (resolved && matched.isEmpty()) {
                        matched.add(permission);
                        marker = "<--";
                    } else {
                        marker = "";
                    }
                    LOGGER.debug("role {}, permission id {}, resolve {} {}", new Object[]{role, permission.getId(), resolved, marker});
                    return false;
                });
            });
        }
        this.roles(exchange).forEachOrdered(role -> this.rolePermissions((String)role).stream().anyMatch(r -> {
            if (r.allow(request)) {
                permissions.add(r);
                return true;
            }
            return false;
        }));
        if (permissions.isEmpty()) {
            return false;
        }
        exchange.putAttachment(BaseAclPermission.MATCHING_ACL_PERMISSION, (Object)((BaseAclPermission)permissions.get(0)));
        return true;
    }

    public boolean isAuthenticationRequired(Request request) {
        if (request.isOptions()) {
            return false;
        }
        HttpServerExchange exchange = request.getExchange();
        LinkedHashSet<MongoAclPermission> ps = this.rolePermissions($UNAUTHENTICATED);
        if (ps != null) {
            if (exchange.getAttachment(Predicate.PREDICATE_CONTEXT) == null) {
                exchange.putAttachment(Predicate.PREDICATE_CONTEXT, new TreeMap());
            }
            exchange.setRelativePath(request.getPath());
            return !ps.stream().anyMatch(r -> r.allow(request));
        }
        return true;
    }

    private Stream<String> roles(HttpServerExchange exchange) {
        return this.account(exchange).getRoles().stream();
    }

    private Account account(HttpServerExchange exchange) {
        Account account = exchange.getSecurityContext().getAuthenticatedAccount();
        return this.isAuthenticated(account) ? account : new NotAuthenticatedAccount();
    }

    private boolean isAuthenticated(Account authenticatedAccount) {
        return authenticatedAccount != null;
    }

    public LinkedHashSet<MongoAclPermission> rolePermissions(String role) {
        if (this.cacheEnabled) {
            Optional _rolePermissions = this.acl.getLoading((Object)role);
            if (_rolePermissions != null && _rolePermissions.isPresent()) {
                return (LinkedHashSet)_rolePermissions.get();
            }
            return null;
        }
        return this.findRolePermissions(role);
    }

    private LinkedHashSet<MongoAclPermission> findRolePermissions(String role) {
        if (this.mclient == null) {
            LOGGER.error("Cannot find acl: mongo service is not enabled.");
            return null;
        }
        FindIterable permissions = this.mclient.getDatabase(this.aclDb).getCollection(this.aclCollection, BsonDocument.class).find(Filters.eq((String)"roles", (Object)role)).projection((Bson)PROJECTION).sort((Bson)SORT);
        if (permissions == null) {
            return new LinkedHashSet<MongoAclPermission>();
        }
        LinkedHashSet ret = Sets.newLinkedHashSet();
        StreamSupport.stream(permissions.spliterator(), true).filter(permissionElem -> permissionElem.isDocument()).map(permissionElem -> permissionElem.asDocument()).filter(permissionDocument -> {
            try {
                MongoAclPermission.build(permissionDocument);
                return true;
            }
            catch (IllegalArgumentException iae) {
                LOGGER.warn("invalid permission _id={}: {}", (Object)permissionDocument.get((Object)"_id"), (Object)iae);
                return false;
            }
        }).map(permissionDocument -> MongoAclPermission.build(permissionDocument)).forEachOrdered(p -> {
            this.registry.getPermissionTransformers().stream().forEach(pt -> pt.transform((BaseAclPermission)p));
            ret.add(p);
        });
        ret.forEach(p -> this.registry.getPermissionTransformers().stream().forEach(pt -> pt.transform((BaseAclPermission)p)));
        return ret;
    }

    public boolean checkAclCollection() {
        if (this.mclient == null) {
            LOGGER.error("Cannot check acl collection: mongo service is not enabled.");
            return false;
        }
        try {
            MongoUtils mu = new MongoUtils(this.mclient);
            if (!mu.doesDbExist(this.aclDb)) {
                mu.createDb(this.aclDb);
            }
            if (!mu.doesCollectionExist(this.aclDb, this.aclCollection)) {
                mu.createCollection(this.aclDb, this.aclCollection);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error creating acl collection", t);
            return false;
        }
        return true;
    }

    private static class NotAuthenticatedAccount
    implements Account {
        private static final long serialVersionUID = -5208703681313492952L;

        private NotAuthenticatedAccount() {
        }

        public Principal getPrincipal() {
            return null;
        }

        public Set<String> getRoles() {
            return Sets.newHashSet((Object[])new String[]{MongoAclAuthorizer.$UNAUTHENTICATED});
        }
    }
}

