/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.interceptors;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.restheart.ConfigurationException;
import org.restheart.exchange.ServiceRequest;
import org.restheart.exchange.ServiceResponse;
import org.restheart.plugins.ConfigurablePlugin;
import org.restheart.plugins.InjectConfiguration;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.WildcardInterceptor;
import org.restheart.utils.LogUtils;
import org.restheart.utils.MetricsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="bruteForceAttackGuard", description="defends from brute force attacks by returning 429 Too Many Requests when failed auth attempts in last 10 seconds from same ip are more than 50%", interceptPoint=InterceptPoint.REQUEST_BEFORE_AUTH, enabledByDefault=false)
public class BruteForceAttackGuard
implements WildcardInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BruteForceAttackGuard.class);
    private static final MetricRegistry AUTH_METRIC_REGISTRY = SharedMetricRegistries.getOrCreate((String)"AUTH");
    private int maxFailedAttempts = 5;

    @InjectConfiguration
    public void config(Map<String, Object> args) {
        try {
            boolean trustXForwardedFor = (Boolean)ConfigurablePlugin.argValue(args, (String)"trust-x-forwarded-for");
            if (trustXForwardedFor) {
                LOGGER.info("Failed auth requests will be counted based on X-Forwarded-For header");
                MetricsUtils.collectFailedAuthBy((MetricsUtils.FAILED_AUTH_KEY)MetricsUtils.FAILED_AUTH_KEY.X_FORWARDED_FOR);
            } else {
                LOGGER.info("Failed auth requests will be counted based on remote ip");
                MetricsUtils.collectFailedAuthBy((MetricsUtils.FAILED_AUTH_KEY)MetricsUtils.FAILED_AUTH_KEY.REMOTE_IP);
            }
        }
        catch (ConfigurationException ce) {
            LOGGER.info("Failed auth requests will be counted based on remote ip");
            MetricsUtils.collectFailedAuthBy((MetricsUtils.FAILED_AUTH_KEY)MetricsUtils.FAILED_AUTH_KEY.REMOTE_IP);
        }
        try {
            this.maxFailedAttempts = (Integer)ConfigurablePlugin.argValue(args, (String)"max-failed-attempts");
        }
        catch (ConfigurationException ce) {
            this.maxFailedAttempts = 5;
        }
        LOGGER.info("Requests will be blocked when got more than {} failed attempts in last 10 seconds", (Object)this.maxFailedAttempts);
    }

    public void handle(ServiceRequest<?> request, ServiceResponse<?> response) throws Exception {
        long max = this.authHisto(request).getSnapshot().getMax();
        if (max > (long)this.maxFailedAttempts) {
            this.logWarning(request.getExchange(), max);
            request.blockForTooManyRequests();
        }
    }

    public boolean resolve(ServiceRequest<?> request, ServiceResponse<?> response) {
        return !request.isOptions();
    }

    private void logWarning(HttpServerExchange exchange, double mean) {
        LogUtils.boxedWarn((Logger)LOGGER, (String[])new String[]{"A brute force attack might be in progress...", "", "Got too many of failed auth attempts in last 10 seconds from:", "", "remote ip: " + ExchangeAttributes.remoteIp().readAttribute(exchange), "X-Forwarded-For header: " + ExchangeAttributes.requestHeader((HttpString)HttpString.tryFromString((String)"X-Forwarded-For")).readAttribute(exchange), "", "transport protocol: " + ExchangeAttributes.transportProtocol().readAttribute(exchange), "request method: " + ExchangeAttributes.requestMethod().readAttribute(exchange), "request url: " + ExchangeAttributes.requestURL().readAttribute(exchange)});
    }

    private Histogram authHisto(ServiceRequest<?> request) {
        return AUTH_METRIC_REGISTRY.histogram(MetricsUtils.failedAuthHistogramName((HttpServerExchange)request.getExchange()), () -> new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(10L, TimeUnit.SECONDS)));
    }
}

