/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.authorizers;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.undertow.predicate.Predicate;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import java.io.FileNotFoundException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.restheart.ConfigurationException;
import org.restheart.exchange.Request;
import org.restheart.plugins.FileConfigurablePlugin;
import org.restheart.plugins.InjectConfiguration;
import org.restheart.plugins.InjectPluginsRegistry;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.Authorizer;
import org.restheart.security.BaseAclPermission;
import org.restheart.security.authorizers.FileAclPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="fileAclAuthorizer", description="authorizes requests according to acl defined in a configuration file", enabledByDefault=false)
public class FileAclAuthorizer
extends FileConfigurablePlugin
implements Authorizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileAclAuthorizer.class);
    public static final String $UNAUTHENTICATED = "$unauthenticated";
    private final Set<FileAclPermission> permissions = new LinkedHashSet<FileAclPermission>();
    private PluginsRegistry registry;
    private boolean permissionsTransformed = false;

    @InjectConfiguration
    public void initConfiguration(Map<String, Object> confArgs) throws FileNotFoundException, ConfigurationException {
        this.init(confArgs, "permissions");
        ArrayList<FileAclPermission> list = new ArrayList<FileAclPermission>(this.permissions);
        Collections.reverse(list);
        this.permissions.clear();
        list.stream().forEach(this.permissions::add);
    }

    @InjectPluginsRegistry
    public void initRegistry(PluginsRegistry registry) throws FileNotFoundException, ConfigurationException {
        this.registry = registry;
    }

    public Consumer<? super Map<String, Object>> consumeConfiguration() {
        return p -> {
            try {
                this.permissions.add(FileAclPermission.build(p));
            }
            catch (ConfigurationException pce) {
                LOGGER.error("Wrong permission", (Throwable)pce);
            }
        };
    }

    private void transformPermissions() {
        this.permissions.forEach(p -> this.registry.getPermissionTransformers().stream().forEach(pt -> pt.transform((BaseAclPermission)p)));
    }

    public boolean isAllowed(Request<?> request) {
        if (!this.permissionsTransformed) {
            this.permissionsTransformed = true;
            this.transformPermissions();
        }
        if (request.isOptions()) {
            return true;
        }
        HttpServerExchange exchange = request.getExchange();
        if (exchange.getAttachment(Predicate.PREDICATE_CONTEXT) == null) {
            exchange.putAttachment(Predicate.PREDICATE_CONTEXT, new TreeMap());
        }
        exchange.setRelativePath(exchange.getRequestPath());
        ArrayList machedPermissions = new ArrayList();
        if (LOGGER.isDebugEnabled()) {
            this.roles(exchange).forEachOrdered(role -> {
                ArrayList matched = Lists.newArrayListWithCapacity((int)1);
                this.rolePermissions((String)role).stream().anyMatch(permission -> {
                    String marker;
                    boolean resolved = permission.allow(request);
                    if (resolved && matched.isEmpty()) {
                        matched.add(permission);
                        marker = "<--";
                    } else {
                        marker = "";
                    }
                    LOGGER.debug("role {}, permission (roles={},predicate={}), resolve {} {}", new Object[]{role, permission.getRoles(), permission.getRequestPredicate(), resolved, marker});
                    return false;
                });
            });
        }
        this.roles(exchange).forEachOrdered(role -> this.rolePermissions((String)role).stream().anyMatch(p -> {
            if (p.allow(request)) {
                machedPermissions.add(p);
                return true;
            }
            return false;
        }));
        if (machedPermissions.isEmpty()) {
            return false;
        }
        exchange.putAttachment(BaseAclPermission.MATCHING_ACL_PERMISSION, (Object)((BaseAclPermission)machedPermissions.get(0)));
        return true;
    }

    public boolean isAuthenticationRequired(Request<?> request) {
        if (request.isOptions()) {
            return false;
        }
        HttpServerExchange exchange = request.getExchange();
        LinkedHashSet<FileAclPermission> ps = this.rolePermissions($UNAUTHENTICATED);
        if (ps != null) {
            if (exchange.getAttachment(Predicate.PREDICATE_CONTEXT) == null) {
                exchange.putAttachment(Predicate.PREDICATE_CONTEXT, new TreeMap());
            }
            exchange.setRelativePath(request.getPath());
            return !ps.stream().anyMatch(r -> r.allow(request));
        }
        return true;
    }

    private Stream<String> roles(HttpServerExchange exchange) {
        return this.account(exchange).getRoles().stream();
    }

    private LinkedHashSet<FileAclPermission> rolePermissions(String role) {
        LinkedHashSet ret = Sets.newLinkedHashSet();
        StreamSupport.stream(this.permissions.spliterator(), true).filter(p -> p.getRoles() != null && p.getRoles().contains(role)).sorted(Comparator.comparingInt(BaseAclPermission::getPriority)).forEachOrdered(p -> ret.add(p));
        return ret;
    }

    private Account account(HttpServerExchange exchange) {
        Account account = exchange.getSecurityContext().getAuthenticatedAccount();
        return this.isAuthenticated(account) ? account : new NotAuthenticatedAccount();
    }

    private boolean isAuthenticated(Account authenticatedAccount) {
        return authenticatedAccount != null;
    }

    private static class NotAuthenticatedAccount
    implements Account {
        private static final long serialVersionUID = 3124L;

        private NotAuthenticatedAccount() {
        }

        public Principal getPrincipal() {
            return null;
        }

        public Set<String> getRoles() {
            return Sets.newHashSet((Object[])new String[]{FileAclAuthorizer.$UNAUTHENTICATED});
        }
    }
}

