/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.authorizers;

import io.undertow.predicate.PredicateParser;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.restheart.ConfigurationException;
import org.restheart.exchange.Request;
import org.restheart.plugins.ConfigurablePlugin;
import org.restheart.security.AclVarsInterpolator;
import org.restheart.security.BaseAclPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAclPermission
extends BaseAclPermission {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileAclPermission.class);
    private final String requestPredicate;

    private FileAclPermission(String requestPredicate, Set<String> roles, int priority, Map<String, Object> raw) throws ConfigurationException {
        super(req -> AclVarsInterpolator.interpolatePredicate((Request)req, (String)requestPredicate, (ClassLoader)FileAclPermission.class.getClassLoader()).resolve(req.getExchange()), roles, priority, raw);
        this.requestPredicate = requestPredicate;
    }

    static FileAclPermission build(Map<String, Object> args) throws ConfigurationException {
        int priority;
        LinkedHashSet<String> roles = new LinkedHashSet<String>();
        if (args.containsKey("role") && args.containsKey("roles")) {
            throw new ConfigurationException("Wrong permission: it specifies both 'role' and 'roles'; it requires just one or the other.");
        }
        if (args.containsKey("role")) {
            roles.add((String)ConfigurablePlugin.argValue(args, (String)"role"));
        } else if (args.containsKey("roles")) {
            roles.addAll((Collection)ConfigurablePlugin.argValue(args, (String)"roles"));
        } else {
            throw new ConfigurationException("Wrong permission: does not specify 'role' or 'roles'.");
        }
        if (!args.containsKey("predicate")) {
            throw new ConfigurationException("Wrong permission: missing 'predicate'");
        }
        String argPredicate = (String)ConfigurablePlugin.argValue(args, (String)"predicate");
        if (argPredicate == null) {
            throw new ConfigurationException("Wrong permission: 'predicate' cannot be null");
        }
        try {
            PredicateParser.parse((String)argPredicate, (ClassLoader)FileAclPermission.class.getClassLoader());
        }
        catch (Throwable t) {
            throw new ConfigurationException("Wrong permission: invalid predicate: " + argPredicate, t);
        }
        if (args.containsKey("priority")) {
            priority = (Integer)ConfigurablePlugin.argValue(args, (String)"priority");
        } else {
            LOGGER.warn("Predicate {} {} doesn't have priority; setting it to very low priority", roles, (Object)argPredicate);
            priority = Integer.MAX_VALUE;
        }
        return new FileAclPermission(argPredicate, roles, priority, args);
    }

    public String getRequestPredicate() {
        return this.requestPredicate;
    }
}

