/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.predicates;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InPredicate
implements Predicate {
    private final String[] array;
    private final ExchangeAttribute value;

    public InPredicate(String[] array, ExchangeAttribute value) {
        this.array = array;
        this.value = value;
    }

    public boolean resolve(HttpServerExchange exchange) {
        return Arrays.stream(this.array).filter(e -> e != null).anyMatch(this.value.readAttribute(exchange)::equals);
    }

    public static class Builder
    implements PredicateBuilder {
        public String name() {
            return "in";
        }

        public Map<String, Class<?>> parameters() {
            HashMap params = Maps.newHashMap();
            params.put("array", String[].class);
            params.put("value", ExchangeAttribute.class);
            return params;
        }

        public Set<String> requiredParameters() {
            return Sets.newHashSet((Object[])new String[]{"array", "value"});
        }

        public String defaultParameter() {
            return null;
        }

        public Predicate build(Map<String, Object> config) {
            return new InPredicate((String[])config.get("array"), (ExchangeAttribute)config.get("value"));
        }
    }
}

