/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.authorizers;

import io.undertow.util.PathTemplate;
import io.undertow.util.PathTemplateMatcher;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.restheart.ConfigurationException;
import org.restheart.exchange.Request;
import org.restheart.plugins.InjectConfiguration;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.Authorizer;
import org.restheart.utils.URLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="originVetoer", description="protects from CSRF attacks by forbidding requests whose Origin header is not whitelisted", enabledByDefault=false, authorizerType=Authorizer.TYPE.VETOER)
public class OriginVetoer
implements Authorizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OriginVetoer.class);
    private List<String> whitelist = null;
    private PathTemplateMatcher<Boolean> ignoreLists = new PathTemplateMatcher();

    @InjectConfiguration
    public void setConfiguration(Map<String, Object> args) {
        try {
            List _whitelist = (List)this.arg(args, "whitelist");
            this.whitelist = _whitelist.stream().filter(item -> item != null).map(item -> item.trim()).map(item -> item.toLowerCase()).map(item -> URLUtils.removeTrailingSlashes((String)item)).map(item -> item.concat("/")).collect(Collectors.toList());
            LOGGER.info("whitelist defined for originVetoer, requests will be accepted with Origin header in {}", this.whitelist);
        }
        catch (ConfigurationException ce) {
            this.whitelist = null;
            LOGGER.info("No whitelist defined for originVetoer, all Origin headers are accepted");
        }
        try {
            List _ingoreList = (List)this.arg(args, "ignore-paths");
            _ingoreList.stream().filter(item -> item != null).map(item -> item.trim()).map(item -> item.toLowerCase()).map(item -> PathTemplate.create((String)item)).forEach(item -> this.ignoreLists.add(item, (Object)true));
            LOGGER.info("ignore list defined for originVetoer, requests will be accepted without checking the Origin header for paths in {}", (Object)_ingoreList);
        }
        catch (ConfigurationException ce) {
            this.ignoreLists = null;
            LOGGER.info("No ignoreLists defined for originVetoer, all paths are checked");
        }
    }

    public boolean isAllowed(Request<?> request) {
        if (this.ignoreLists != null && this.ignoreLists.match(request.getPath()) != null) {
            LOGGER.debug("originVetoer: request is accepted since path is in ignore list");
            return true;
        }
        if (this.whitelist == null || this.whitelist.isEmpty()) {
            return true;
        }
        String origin = request.getHeader("Origin");
        if (origin == null) {
            LOGGER.warn("request forbidden by originVetoer due to missing Origin header, whitelist is {}", this.whitelist);
            return false;
        }
        boolean allowed = this.whitelist.stream().anyMatch(wl -> URLUtils.removeTrailingSlashes((String)origin.toLowerCase()).concat("/").startsWith((String)wl));
        if (!allowed) {
            LOGGER.warn("request forbidden by originVetoer due to Origin header {} not in whitelist {}", (Object)origin, this.whitelist);
        }
        return allowed;
    }

    public boolean isAuthenticationRequired(Request request) {
        return false;
    }
}

