/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.services;

import io.undertow.server.HttpServerExchange;
import java.util.Map;
import org.restheart.ConfigurationException;
import org.restheart.exchange.JsonRequest;
import org.restheart.exchange.JsonResponse;
import org.restheart.exchange.ServiceRequest;
import org.restheart.plugins.InjectConfiguration;
import org.restheart.plugins.JsonService;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.TokenManager;
import org.restheart.utils.GsonUtils;
import org.restheart.utils.URLUtils;

@RegisterPlugin(name="roles", description="returns the roles of the authenticated client", secure=false, enabledByDefault=true, defaultURI="/roles")
public class GetRoleService
implements JsonService {
    private String myURI = null;

    @InjectConfiguration
    public void init(Map<String, Object> confArgs) {
        if (confArgs == null) {
            this.myURI = "/roles";
        }
        try {
            this.myURI = URLUtils.removeTrailingSlashes((String)((String)this.arg(confArgs, "uri")));
        }
        catch (ConfigurationException ex) {
            this.myURI = "/roles";
        }
    }

    public void handle(JsonRequest request, JsonResponse response) throws Exception {
        HttpServerExchange exchange = request.getExchange();
        switch (request.getMethod()) {
            case GET: {
                if (this.checkRequestPath(request)) {
                    GsonUtils.ArrayBuilder roles = GsonUtils.array();
                    request.getAuthenticatedAccount().getRoles().forEach(xva$0 -> roles.add(new String[]{xva$0}));
                    response.setContent(GsonUtils.object().put("authenticated", true).put("roles", roles));
                    break;
                }
                exchange.setStatusCode(403);
                response.getHeaders().remove(TokenManager.AUTH_TOKEN_HEADER);
                response.getHeaders().remove(TokenManager.AUTH_TOKEN_VALID_HEADER);
                response.getHeaders().remove(TokenManager.AUTH_TOKEN_LOCATION_HEADER);
                exchange.endExchange();
                return;
            }
            case OPTIONS: {
                this.handleOptions((ServiceRequest)request);
                break;
            }
            default: {
                exchange.setStatusCode(405);
                exchange.endExchange();
            }
        }
    }

    private boolean checkRequestPath(JsonRequest request) {
        return request.getAuthenticatedAccount() != null && request.getAuthenticatedAccount().getPrincipal() != null && request.getAuthenticatedAccount().getPrincipal().getName() != null && request.getAuthenticatedAccount().getRoles() != null && request.getPath().equals(this.myURI + "/" + request.getAuthenticatedAccount().getPrincipal().getName());
    }
}

