/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.mechanisms;

import com.google.common.collect.Sets;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.restheart.ConfigurationException;
import org.restheart.plugins.InjectConfiguration;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.AuthMechanism;
import org.restheart.security.BaseAccount;

@RegisterPlugin(name="identityAuthMechanism", description="authenticates all requests against the configured IdentityManager using the credentials specified in the configuration file", enabledByDefault=false)
public class IdentityAuthMechanism
implements AuthMechanism {
    private String username;
    private List<String> roles;

    @InjectConfiguration
    public void init(Map<String, Object> confArgs) throws ConfigurationException {
        this.username = (String)this.arg(confArgs, "username");
        this.roles = (List)this.arg(confArgs, "roles");
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        BaseAccount sa = new BaseAccount(this.username, (Set)Sets.newTreeSet(this.roles));
        securityContext.authenticationComplete((Account)sa, "IdentityAuthenticationManager", true);
        return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(200));
    }
}

