/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.mechanisms;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.FlexBase64;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.restheart.ConfigurationException;
import org.restheart.plugins.InjectPluginsRegistry;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.AuthMechanism;
import org.restheart.plugins.security.TokenManager;

@RegisterPlugin(name="tokenBasicAuthMechanism", description="authenticates the requests using the configured Token Manager", enabledByDefault=false, priority=-2147483648)
public class TokenBasicAuthMechanism
extends BasicAuthenticationMechanism
implements AuthMechanism {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String BASIC_PREFIX = String.valueOf(Headers.BASIC) + " ";
    private static final int PREFIX_LENGTH = BASIC_PREFIX.length();
    private static final String COLON = ":";
    private TokenManager tokenManager = null;

    private static void clear(char[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = '\u0000';
        }
    }

    public TokenBasicAuthMechanism() throws ConfigurationException {
        super("RESTHeart Realm", "tokenBasicAuthMechanism", true);
    }

    @InjectPluginsRegistry
    public void init(PluginsRegistry pluginsRegistry) throws ConfigurationException {
        this.tokenManager = pluginsRegistry.getTokenManager() != null ? (TokenManager)pluginsRegistry.getTokenManager().getInstance() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        HeaderValues authHeaders = exchange.getRequestHeaders().get(Headers.AUTHORIZATION);
        if (authHeaders != null) {
            for (String current : authHeaders) {
                int colonPos;
                if (!current.startsWith(BASIC_PREFIX)) continue;
                String base64Challenge = current.substring(PREFIX_LENGTH);
                String plainChallenge = null;
                try {
                    ByteBuffer decode = FlexBase64.decode((String)base64Challenge);
                    plainChallenge = new String(decode.array(), decode.arrayOffset(), decode.limit(), UTF_8);
                }
                catch (IOException decode) {
                    // empty catch block
                }
                if (plainChallenge != null && (colonPos = plainChallenge.indexOf(COLON)) > -1) {
                    String userName = plainChallenge.substring(0, colonPos);
                    char[] password = plainChallenge.substring(colonPos + 1).toCharArray();
                    PasswordCredential credential = new PasswordCredential(password);
                    try {
                        AuthenticationMechanism.AuthenticationMechanismOutcome result;
                        Account account = this.tokenManager.verify(userName, (Credential)credential);
                        if (account != null) {
                            securityContext.authenticationComplete(account, this.getMechanismName(), false);
                            result = AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                        } else {
                            result = AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
                        }
                        AuthenticationMechanism.AuthenticationMechanismOutcome authenticationMechanismOutcome = result;
                        return authenticationMechanismOutcome;
                    }
                    finally {
                        TokenBasicAuthMechanism.clear(password);
                    }
                }
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
            }
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        String authHeader = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
        if (authHeader == null) {
            return new AuthenticationMechanism.ChallengeResult(false);
        }
        return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(401));
    }
}

