/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.tokens;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.collect.Sets;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.server.HttpServerExchange;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.restheart.cache.Cache;
import org.restheart.cache.CacheFactory;
import org.restheart.cache.LoadingCache;
import org.restheart.configuration.ConfigurationException;
import org.restheart.exchange.Request;
import org.restheart.plugins.ConfigurablePlugin;
import org.restheart.plugins.Inject;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.TokenManager;
import org.restheart.security.BaseAccount;
import org.restheart.security.PwdCredentialAccount;
import org.restheart.security.tokens.ComparableAccount;
import org.restheart.security.tokens.Token;
import org.restheart.utils.URLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="jwtTokenManager", description="issues and verifies auth tokens in a cluster compatible way", enabledByDefault=false)
public class JwtTokenManager
implements TokenManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtTokenManager.class);
    private LoadingCache<ComparableAccount, Token> jwtCache;
    private JWTVerifier verifier;
    private JWTCreator.Builder creator;
    private Algorithm algo;
    private String srvURI = "/tokens";
    private int ttl = 15;
    private String issuer = "restheart.com";
    private static final int MAX_CACHE_SIZE = 1000;
    private boolean enabled = false;
    @Inject(value="config")
    Map<String, Object> config;

    @OnInit
    public void init() throws ConfigurationException {
        this.enabled = true;
        this.srvURI = (String)ConfigurablePlugin.argValue(this.config, (String)"srv-uri");
        this.ttl = (Integer)ConfigurablePlugin.argValue(this.config, (String)"ttl");
        if (this.ttl < 1) {
            this.enabled = false;
            throw new ConfigurationException("TTL minimum value is 1 minute");
        }
        this.algo = Algorithm.HMAC256((String)((String)ConfigurablePlugin.argValue(this.config, (String)"key")));
        this.issuer = (String)ConfigurablePlugin.argValue(this.config, (String)"issuer");
        this.jwtCache = CacheFactory.createLocalLoadingCache((long)1000L, (Cache.EXPIRE_POLICY)Cache.EXPIRE_POLICY.AFTER_WRITE, (long)(this.ttl * 1000 * 60 - 500), account -> this.newToken(account.wrapped));
        try {
            this.verifier = JWT.require((Algorithm)this.algo).withIssuer(this.issuer).build();
            this.creator = JWT.create().withIssuer(this.issuer);
        }
        catch (Throwable t) {
            this.enabled = false;
            LOGGER.error("error", t);
            throw new ConfigurationException("error ");
        }
    }

    public Account verify(Account account) {
        return this.enabled ? account : null;
    }

    public Account verify(String id, Credential credential) {
        if (!this.enabled) {
            return null;
        }
        if (id != null && credential instanceof PasswordCredential) {
            char[] token = ((PasswordCredential)credential).getPassword();
            ComparableAccount ca = new ComparableAccount((Account)new BaseAccount(id, null));
            if (this.jwtCache.get((Object)ca) != null && this.jwtCache.get((Object)ca).isPresent() && Arrays.equals(token, ((Token)this.jwtCache.get((Object)ca).get()).raw)) {
                LOGGER.debug("jwt token in cache");
                return new PwdCredentialAccount(id, token, (Set)Sets.newHashSet((Object[])((Token)this.jwtCache.get((Object)ca).get()).roles));
            }
            LOGGER.trace("jwt token not in cache, let's verify it");
            try {
                DecodedJWT decoded = this.verifier.verify(new String(token));
                if (id.equals(decoded.getSubject())) {
                    Object[] roles = (String[])decoded.getClaim("roles").asArray(String.class);
                    LOGGER.trace("******************** valid token from user {}", (Object)id);
                    return new PwdCredentialAccount(id, token, (Set)Sets.newHashSet((Object[])roles));
                }
                LOGGER.warn("invalid token from user {}, not matching id in token, was {}", (Object)id, (Object)decoded.getSubject());
                return null;
            }
            catch (Throwable t) {
                LOGGER.debug("expired or invalid token from user {}, {}", (Object)id, (Object)t.getMessage());
                return null;
            }
        }
        return null;
    }

    public Account verify(Credential credential) {
        return null;
    }

    public PasswordCredential get(Account account) {
        if (!this.enabled) {
            return null;
        }
        if (account == null || account.getPrincipal() == null || account.getPrincipal().getName() == null) {
            return null;
        }
        Token token = (Token)this.jwtCache.getLoading((Object)new ComparableAccount(account)).get();
        PwdCredentialAccount newTokenAccount = new PwdCredentialAccount(account.getPrincipal().getName(), token.raw, (Set)Sets.newTreeSet((Iterable)account.getRoles()));
        return newTokenAccount.getCredentials();
    }

    private Token newToken(Account account) {
        Date expires = Date.from(Instant.now().plus((long)this.ttl, ChronoUnit.MINUTES));
        String raw = this.creator.withSubject(account.getPrincipal().getName()).withExpiresAt(expires).withIssuer(this.issuer).withArrayClaim("roles", account.getRoles().toArray(new String[account.getRoles().size()])).sign(this.algo);
        return new Token(raw.toCharArray(), expires, account.getRoles().toArray(new String[0]));
    }

    public void invalidate(Account account) {
        if (!this.enabled) {
            return;
        }
        this.jwtCache.invalidate((Object)new ComparableAccount(account));
    }

    public void update(Account account) {
        if (!this.enabled) {
            return;
        }
        ComparableAccount ca = new ComparableAccount(account);
        this.jwtCache.put((Object)ca, (Object)((Token)this.jwtCache.getLoading((Object)ca).get()));
    }

    public void injectTokenHeaders(HttpServerExchange exchange, PasswordCredential token) {
        if (!this.enabled) {
            return;
        }
        Request request = Request.of((HttpServerExchange)exchange);
        if (request.getAuthenticatedAccount() != null && request.getAuthenticatedAccount().getPrincipal() != null && request.getAuthenticatedAccount().getPrincipal().getName() != null) {
            Account account = request.getAuthenticatedAccount();
            ComparableAccount ca = new ComparableAccount(account);
            String cid = request.getAuthenticatedAccount().getPrincipal().getName();
            exchange.getResponseHeaders().add(AUTH_TOKEN_LOCATION_HEADER, URLUtils.removeTrailingSlashes((String)this.srvURI).concat("/").concat(cid));
            if (exchange.getQueryParameters().containsKey("renew-auth-token")) {
                Token newToken = this.newToken(account);
                this.jwtCache.put((Object)ca, (Object)newToken);
                exchange.getResponseHeaders().add(AUTH_TOKEN_HEADER, new String(newToken.raw));
                exchange.getResponseHeaders().add(AUTH_TOKEN_VALID_HEADER, newToken.getDateAsString());
            } else if (this.jwtCache.get((Object)ca) != null) {
                Token cachedToken = (Token)this.jwtCache.get((Object)ca).get();
                exchange.getResponseHeaders().add(AUTH_TOKEN_HEADER, new String(cachedToken.raw));
                exchange.getResponseHeaders().add(AUTH_TOKEN_VALID_HEADER, cachedToken.getDateAsString());
            }
        }
    }
}

