/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.tokens;

import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;

class Token {
    public final char[] raw;
    public final Date expires;
    public final String[] roles;

    public Token(char[] raw, Date expires, String[] roles) {
        this.raw = raw;
        this.expires = expires;
        this.roles = roles;
    }

    public Token(DecodedJWT jwt) {
        this.raw = jwt.getToken().toCharArray();
        this.expires = jwt.getExpiresAt();
        this.roles = (String[])jwt.getClaim("roles").asArray(String.class);
    }

    public String getDateAsString() {
        return this.expires.toInstant().toString();
    }
}

