/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.authenticators;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.DigestCredential;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.util.HexConverter;
import io.undertow.util.HttpString;
import io.undertow.util.RedirectBuilder;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import org.bson.BsonDocument;
import org.mindrot.jbcrypt.BCrypt;
import org.restheart.cache.Cache;
import org.restheart.cache.CacheFactory;
import org.restheart.cache.LoadingCache;
import org.restheart.configuration.ConfigurationException;
import org.restheart.mongodb.ConnectionChecker;
import org.restheart.plugins.Inject;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.Authenticator;
import org.restheart.plugins.security.TokenManager;
import org.restheart.security.MongoRealmAccount;
import org.restheart.security.PwdCredentialAccount;
import org.restheart.security.utils.MongoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="mongoRealmAuthenticator", description="authenticate requests against client credentials stored in mongodb")
public class MongoRealmAuthenticator
implements Authenticator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoRealmAuthenticator.class);
    public static final String X_FORWARDED_ACCOUNT_ID = "rhAuthenticator";
    public static final String X_FORWARDED_ROLE = "RESTHeart";
    private String propId = "_id";
    String usersDb;
    String usersCollection;
    String propPassword = "password";
    private String jsonPathRoles = "$.roles";
    private Boolean bcryptHashedPassword = false;
    Integer bcryptComplexity = 12;
    private Boolean enforceMinimumPasswordStrenght = false;
    private Integer minimumPasswordStrength = 3;
    private Boolean createUser = false;
    private BsonDocument createUserDocument = null;
    private Boolean cacheEnabled = false;
    private Integer cacheSize = 1000;
    private Integer cacheTTL = 60000;
    private Cache.EXPIRE_POLICY cacheExpirePolicy = Cache.EXPIRE_POLICY.AFTER_WRITE;
    private LoadingCache<String, MongoRealmAccount> USERS_CACHE = null;
    private static final transient Cache<String, String> USERS_PWDS_CACHE = CacheFactory.createLocalCache((long)1000L, (Cache.EXPIRE_POLICY)Cache.EXPIRE_POLICY.AFTER_READ, (long)1200000L);
    @Inject(value="registry")
    private PluginsRegistry registry;
    @Inject(value="config")
    Map<String, Object> config;
    @Inject(value="mclient")
    private MongoClient mclient;

    @OnInit
    public void init() {
        this.setUsersDb((String)this.arg(this.config, "users-db"));
        this.usersCollection = (String)this.arg(this.config, "users-collection");
        this.cacheEnabled = (Boolean)this.arg(this.config, "cache-enabled");
        this.cacheSize = (Integer)this.arg(this.config, "cache-size");
        this.cacheTTL = (Integer)this.arg(this.config, "cache-ttl");
        String _cacheExpirePolicy = (String)this.arg(this.config, "cache-expire-policy");
        if (_cacheExpirePolicy != null) {
            try {
                this.cacheExpirePolicy = Cache.EXPIRE_POLICY.valueOf((String)_cacheExpirePolicy);
            }
            catch (IllegalArgumentException iae) {
                throw new ConfigurationException("wrong configuration file format. cache-expire-policy valid values are ".concat(Arrays.toString(Cache.EXPIRE_POLICY.values())));
            }
        }
        this.enforceMinimumPasswordStrenght = (Boolean)this.argOrDefault(this.config, "enforce-minimum-password-strength", false);
        this.minimumPasswordStrength = (Integer)this.argOrDefault(this.config, "minimum-password-strength", 3);
        this.bcryptHashedPassword = (Boolean)this.arg(this.config, "bcrypt-hashed-password");
        this.bcryptComplexity = (Integer)this.arg(this.config, "bcrypt-complexity");
        this.createUser = (Boolean)this.arg(this.config, "create-user");
        String _createUserDocument = (String)this.arg(this.config, "create-user-document");
        try {
            this.createUserDocument = BsonDocument.parse((String)_createUserDocument);
        }
        catch (JsonParseException ex) {
            throw new ConfigurationException("wrong configuration file format. create-user-document must be a json document", (Throwable)ex);
        }
        this.propId = (String)this.arg(this.config, "prop-id");
        if (this.propId.startsWith("$")) {
            throw new ConfigurationException("prop-id must be a root property name not a json path expression. It can use the dot notation.");
        }
        this.propPassword = (String)this.arg(this.config, "prop-password");
        if (this.propPassword.contains(".")) {
            throw new ConfigurationException("prop-password must be a root level property and cannot contain the char '.'");
        }
        this.jsonPathRoles = (String)this.arg(this.config, "json-path-roles");
        if (this.cacheEnabled.booleanValue()) {
            this.USERS_CACHE = CacheFactory.createLocalLoadingCache((long)this.cacheSize.intValue(), (Cache.EXPIRE_POLICY)this.cacheExpirePolicy, (long)this.cacheTTL.intValue(), key -> this.findAccount(this.accountIdTrasformer((String)key)));
        }
        try {
            if (!this.checkUserCollection()) {
                LOGGER.error("Users collection does not exist and could not be created");
            } else if (this.createUser.booleanValue()) {
                LOGGER.trace("Create user option enabled");
                if (this.countAccounts() < 1L) {
                    this.createDefaultAccount();
                    LOGGER.info("No user found. Created default user with _id {}", (Object)this.createUserDocument.get((Object)this.propId));
                } else {
                    LOGGER.trace("Not creating default user since users exist");
                }
            }
        }
        catch (IllegalStateException ise) {
            LOGGER.error(ise.getMessage());
        }
    }

    public Account verify(Account account) {
        return account;
    }

    public Account verify(String id, Credential credential) {
        boolean verified;
        if (credential == null) {
            LOGGER.debug("cannot verify null credential");
            return null;
        }
        MongoRealmAccount ref = this.getAccount(id);
        if (credential instanceof PasswordCredential) {
            PasswordCredential passwordCredential = (PasswordCredential)credential;
            verified = this.verifyPasswordCredential((PwdCredentialAccount)ref, passwordCredential);
        } else if (credential instanceof DigestCredential) {
            DigestCredential digestCredential = (DigestCredential)credential;
            verified = this.verifyDigestCredential((PwdCredentialAccount)ref, digestCredential);
        } else {
            LOGGER.warn("mongoRealmAuthenticator does not support credential of type {}", (Object)credential.getClass().getSimpleName());
            verified = false;
        }
        if (verified) {
            this.updateAuthTokenCache((PwdCredentialAccount)ref);
            return ref;
        }
        return null;
    }

    public Integer getBcryptComplexity() {
        return this.bcryptComplexity;
    }

    public boolean isBcryptHashedPassword() {
        return this.bcryptHashedPassword;
    }

    public Integer getMinimumPasswordStrength() {
        return this.minimumPasswordStrength;
    }

    public boolean isEnforceMinimumPasswordStrenght() {
        return this.enforceMinimumPasswordStrenght;
    }

    private boolean verifyPasswordCredential(PwdCredentialAccount ref, PasswordCredential credential) {
        if (ref == null || ref.getPrincipal() == null || ref.getPrincipal().getName() == null || ref.getCredentials() == null || ref.getCredentials().getPassword() == null || credential == null || credential.getPassword() == null) {
            return false;
        }
        return MongoRealmAuthenticator.checkPassword(ref.getPrincipal().getName(), this.bcryptHashedPassword, credential.getPassword(), ref.getCredentials().getPassword());
    }

    private boolean verifyDigestCredential(PwdCredentialAccount ref, DigestCredential credential) {
        if (this.bcryptHashedPassword.booleanValue()) {
            LOGGER.error("Digest authentication cannot support bcryped stored password, consider using basic authetication over TLS");
            return false;
        }
        if (ref == null || ref.getCredentials() == null || ref.getCredentials().getPassword() == null || ref.getPrincipal() == null || ref.getPrincipal().getName() == null || credential == null) {
            return false;
        }
        try {
            MessageDigest digest = credential.getAlgorithm().getMessageDigest();
            digest.update(ref.getPrincipal().getName().getBytes(RedirectBuilder.UTF_8));
            digest.update((byte)58);
            digest.update(credential.getRealm().getBytes(RedirectBuilder.UTF_8));
            digest.update((byte)58);
            digest.update(new String(ref.getCredentials().getPassword()).getBytes(RedirectBuilder.UTF_8));
            byte[] ha1 = HexConverter.convertToHexBytes((byte[])digest.digest());
            return credential.verifyHA1(ha1);
        }
        catch (NoSuchAlgorithmException ne) {
            LOGGER.error(ne.getMessage(), (Throwable)ne);
            return false;
        }
        catch (UnsupportedEncodingException usc) {
            LOGGER.error(usc.getMessage(), (Throwable)usc);
            return false;
        }
    }

    public Account verify(Credential credential) {
        return null;
    }

    static boolean checkPassword(String username, boolean hashed, char[] password, char[] expected) {
        if (hashed) {
            if (username == null || password == null || expected == null) {
                return false;
            }
            String _password = new String(password);
            String _expected = new String(expected);
            Optional _cachedPwd = USERS_PWDS_CACHE.get((Object)username.concat(_expected));
            if (_cachedPwd != null && _cachedPwd.isPresent() && ((String)_cachedPwd.get()).equals(_password)) {
                return true;
            }
            try {
                boolean check = BCrypt.checkpw((String)_password, (String)_expected);
                if (check) {
                    USERS_PWDS_CACHE.put((Object)username.concat(_expected), (Object)_password);
                    return true;
                }
                return false;
            }
            catch (Throwable t) {
                USERS_PWDS_CACHE.invalidate((Object)username.concat(_expected));
                LOGGER.warn("Error checking bcryped pwd hash", t);
                return false;
            }
        }
        return Arrays.equals(password, expected);
    }

    private MongoRealmAccount getAccount(String id) {
        if (this.mclient == null) {
            LOGGER.error("Cannot find account: mongo service is not enabled.");
            return null;
        }
        if (this.USERS_CACHE == null) {
            return this.findAccount(this.accountIdTrasformer(id));
        }
        Optional _account = this.USERS_CACHE.getLoading((Object)id);
        if (_account != null && _account.isPresent()) {
            return (MongoRealmAccount)_account.get();
        }
        return null;
    }

    protected String accountIdTrasformer(String id) {
        return id;
    }

    private void updateAuthTokenCache(PwdCredentialAccount account) {
        try {
            TokenManager tm;
            PluginRecord _tm = this.registry.getTokenManager();
            if (_tm != null && (tm = (TokenManager)_tm.getInstance()).get((Account)account) != null) {
                tm.update((Account)account);
            }
        }
        catch (ConfigurationException pce) {
            LOGGER.warn("error getting the token manager", (Throwable)pce);
        }
    }

    public String getPropPassword() {
        return this.propPassword;
    }

    public static HttpString getXForwardedHeaderName(String suffix) {
        return HttpString.tryFromString((String)"X-Forwarded-".concat(suffix));
    }

    public static HttpString getXForwardedAccountIdHeaderName() {
        return MongoRealmAuthenticator.getXForwardedHeaderName("Account-Id");
    }

    public static HttpString getXForwardedRolesHeaderName() {
        return MongoRealmAuthenticator.getXForwardedHeaderName("Account-Roles");
    }

    public boolean checkUserCollection() throws IllegalStateException {
        if (this.mclient == null) {
            throw new IllegalStateException("Cannot check user collection: mongo service is not enabled.");
        }
        if (!ConnectionChecker.connected((MongoClient)this.mclient)) {
            throw new IllegalStateException("Cannot check user collection: MongoDB not connected.");
        }
        try {
            MongoUtils mu = new MongoUtils(this.mclient);
            if (!mu.doesDbExist(this.usersDb)) {
                mu.createDb(this.usersDb);
            }
            if (!mu.doesCollectionExist(this.usersDb, this.usersCollection)) {
                mu.createCollection(this.usersDb, this.usersCollection);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error creating users collection", t);
            return false;
        }
        return true;
    }

    public long countAccounts() {
        try {
            return this.mclient.getDatabase(this.getUsersDb()).getCollection(this.getUsersCollection()).estimatedDocumentCount();
        }
        catch (Throwable t) {
            LOGGER.error("Error counting accounts", t);
            return 1L;
        }
    }

    public void createDefaultAccount() {
        if (this.mclient == null) {
            LOGGER.error("Cannot find account: mongo service is not enabled.");
            return;
        }
        if (this.createUserDocument != null) {
            try {
                this.mclient.getDatabase(this.getUsersDb()).getCollection(this.getUsersCollection()).withDocumentClass(BsonDocument.class).insertOne((Object)this.createUserDocument);
            }
            catch (Throwable t) {
                LOGGER.error("Error creating default account", t);
            }
        }
    }

    public MongoRealmAccount findAccount(String accountId) {
        JsonElement _roles;
        JsonElement _password;
        JsonElement account;
        BsonDocument _account;
        MongoCollection coll = this.mclient.getDatabase(this.getUsersDb()).getCollection(this.getUsersCollection()).withDocumentClass(BsonDocument.class);
        try {
            _account = (BsonDocument)coll.find(Filters.eq((String)this.propId, (Object)accountId)).first();
        }
        catch (Throwable t) {
            LOGGER.error("Error finding account {}", (Object)this.propId, (Object)t);
            return null;
        }
        if (_account == null) {
            return null;
        }
        try {
            account = (JsonElement)JsonPath.read((String)_account.toJson(), (String)"$", (Predicate[])new Predicate[0]);
        }
        catch (PathNotFoundException | IllegalArgumentException pnfe) {
            LOGGER.warn("Cannot find account {}", (Object)accountId);
            return null;
        }
        if (!account.isJsonObject()) {
            LOGGER.warn("Retrived document for account {} is not an object", (Object)accountId);
            return null;
        }
        try {
            DocumentContext ctx = JsonPath.parse((Object)account);
            _password = (JsonElement)ctx.read("$.".concat(this.propPassword), new Predicate[0]);
            account = (JsonElement)ctx.delete("$.".concat(this.propPassword), new Predicate[0]).json();
        }
        catch (PathNotFoundException pnfe) {
            LOGGER.warn("Cannot find pwd property '{}' for account {}", (Object)this.propPassword, (Object)accountId);
            return null;
        }
        if (!_password.isJsonPrimitive() || !_password.getAsJsonPrimitive().isString()) {
            LOGGER.warn("Pwd property of account {} is not a string", (Object)accountId);
            return null;
        }
        try {
            _roles = (JsonElement)JsonPath.read((Object)account, (String)this.jsonPathRoles, (Predicate[])new Predicate[0]);
        }
        catch (PathNotFoundException pnfe) {
            LOGGER.warn("Account with id: {} does not have roles");
            _roles = new JsonArray();
        }
        if (!_roles.isJsonArray()) {
            LOGGER.warn("Roles property of account {} is not an array", (Object)accountId);
            return null;
        }
        LinkedHashSet roles = new LinkedHashSet();
        _roles.getAsJsonArray().forEach(role -> {
            if (role != null && role.isJsonPrimitive() && role.getAsJsonPrimitive().isString()) {
                roles.add(role.getAsJsonPrimitive().getAsString());
            } else {
                LOGGER.warn("A role of account {} is not a string", (Object)accountId);
            }
        });
        return new MongoRealmAccount(accountId, _password.getAsJsonPrimitive().getAsString().toCharArray(), roles, BsonDocument.parse((String)account.toString()));
    }

    public String getUsersDb() {
        return this.usersDb;
    }

    public void setUsersDb(String usersDb) {
        this.usersDb = usersDb;
    }

    public String getUsersCollection() {
        return this.usersCollection;
    }
}

