/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.authenticators;

import org.bson.BsonDocument;
import org.restheart.configuration.ConfigurationException;
import org.restheart.exchange.MongoRequest;
import org.restheart.exchange.MongoResponse;
import org.restheart.plugins.Inject;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.MongoInterceptor;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.security.authenticators.MongoRealmAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="denyFilterOnUserPwd", description="forbids request with filter on the password property", interceptPoint=InterceptPoint.RESPONSE, requiresContent=true)
public class DenyFilterOnUserPwd
implements MongoInterceptor {
    static final Logger LOGGER = LoggerFactory.getLogger(DenyFilterOnUserPwd.class);
    private boolean enabled = false;
    private String usersDb;
    private String usersCollection;
    private String propNamePassword;
    @Inject(value="registry")
    PluginsRegistry registry;

    @OnInit
    public void init() {
        PluginRecord _mra;
        try {
            _mra = this.registry.getAuthenticator("mongoRealmAuthenticator");
        }
        catch (ConfigurationException ce) {
            this.enabled = false;
            return;
        }
        if (_mra == null || !_mra.isEnabled()) {
            this.enabled = false;
        } else {
            MongoRealmAuthenticator rhAuth = (MongoRealmAuthenticator)_mra.getInstance();
            this.usersDb = rhAuth.getUsersDb();
            this.usersCollection = rhAuth.getUsersCollection();
            this.propNamePassword = rhAuth.getPropPassword();
            if (this.usersDb == null || this.usersCollection == null || this.propNamePassword == null) {
                LOGGER.error("Wrong configuration of mongoRealmAuthenticator! Requests with filters on the password property are not blocked!");
                this.enabled = false;
            } else {
                this.enabled = true;
            }
        }
    }

    public boolean resolve(MongoRequest request, MongoResponse response) {
        return this.enabled && request.isGet() && this.usersDb.equalsIgnoreCase(request.getDBName()) && this.usersCollection.equalsIgnoreCase(request.getCollectionName()) && this.hasFilterOnPassword(request.getFiltersDocument());
    }

    public void handle(MongoRequest request, MongoResponse response) throws Exception {
        response.setInError(403, "Using filters on the password property is forbidden");
    }

    private boolean hasFilterOnPassword(BsonDocument filters) {
        if (filters == null || filters.keySet().isEmpty()) {
            return false;
        }
        return filters.keySet().contains(this.propNamePassword) || filters.keySet().stream().filter(key -> filters.get(key).isDocument()).map(key -> filters.get(key).asDocument()).anyMatch(doc -> this.hasFilterOnPassword((BsonDocument)doc));
    }
}

