/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.mechanisms;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.server.HttpServerExchange;
import java.lang.reflect.Field;
import java.util.Map;
import org.restheart.configuration.ConfigurationException;
import org.restheart.plugins.Inject;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.AuthMechanism;

@RegisterPlugin(name="basicAuthMechanism", description="handles the basic authentication scheme", enabledByDefault=false)
public class BasicAuthMechanism
extends BasicAuthenticationMechanism
implements AuthMechanism {
    public static final String SILENT_HEADER_KEY = "No-Auth-Challenge";
    public static final String SILENT_QUERY_PARAM_KEY = "noauthchallenge";
    @Inject(value="config")
    private Map<String, Object> config;
    @Inject(value="registry")
    private PluginsRegistry registry;

    public BasicAuthMechanism() throws ConfigurationException {
        super("RESTHeart Realm", "basicAuthMechanism", false);
    }

    @OnInit
    public void init() throws ConfigurationException {
        String authenticatorName = (String)this.arg(this.config, "authenticator");
        try {
            PluginRecord authenticator = this.registry.getAuthenticator(authenticatorName);
            if (authenticator == null) {
                throw new ConfigurationException("authenticator " + authenticatorName + " is not available");
            }
            this.setIdentityManager((IdentityManager)authenticator.getInstance());
        }
        catch (ConfigurationException ce) {
            throw new ConfigurationException("authenticator " + authenticatorName + " is not available. check configuration option /basicAuthMechanism/authenticator");
        }
    }

    private void setIdentityManager(IdentityManager idm) {
        try {
            Class<?> clazz = Class.forName("io.undertow.security.impl.BasicAuthenticationMechanism");
            Field idmF = clazz.getDeclaredField("identityManager");
            idmF.setAccessible(true);
            idmF.set((Object)this, idm);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException("Error setting identity manager", ex);
        }
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        if (exchange.getRequestHeaders().contains(SILENT_HEADER_KEY) || exchange.getQueryParameters().containsKey(SILENT_QUERY_PARAM_KEY)) {
            return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(401));
        }
        return super.sendChallenge(exchange, securityContext);
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        return super.authenticate(exchange, securityContext);
    }
}

