/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.authenticators;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mindrot.jbcrypt.BCrypt;
import org.restheart.configuration.ConfigurationException;
import org.restheart.exchange.MongoRequest;
import org.restheart.exchange.MongoResponse;
import org.restheart.plugins.Inject;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.MongoInterceptor;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.security.authenticators.MongoRealmAuthenticator;
import org.restheart.utils.BsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="userPwdHasher", description="automatically hashes the user password", interceptPoint=InterceptPoint.REQUEST_AFTER_AUTH, requiresContent=true)
public class UserPwdHasher
implements MongoInterceptor {
    static final Logger LOGGER = LoggerFactory.getLogger(UserPwdHasher.class);
    private String usersDb;
    private String usersCollection;
    private String propNamePassword;
    private Integer complexity;
    private boolean enabled = false;
    @Inject(value="registry")
    private PluginsRegistry registry;

    @OnInit
    public void init() {
        PluginRecord _mra;
        try {
            _mra = this.registry.getAuthenticator("mongoRealmAuthenticator");
        }
        catch (ConfigurationException ce) {
            this.enabled = false;
            return;
        }
        if (_mra == null || !_mra.isEnabled()) {
            this.enabled = false;
        } else {
            MongoRealmAuthenticator rhAuth = (MongoRealmAuthenticator)_mra.getInstance();
            if (!rhAuth.isBcryptHashedPassword()) {
                this.enabled = false;
                return;
            }
            this.usersDb = rhAuth.getUsersDb();
            this.usersCollection = rhAuth.getUsersCollection();
            this.propNamePassword = rhAuth.getPropPassword();
            this.complexity = rhAuth.getBcryptComplexity();
            if (this.usersDb == null || this.usersCollection == null || this.propNamePassword == null || this.complexity == null) {
                LOGGER.error("Wrong configuration of mongoRealmAuthenticator! Password field of users documents is not automatically entcrypted: {usersDb: {}, usersCollection: {}, propNamePassword: {}, complexity: {}})", new Object[]{this.usersDb, this.usersCollection, this.propNamePassword, this.complexity});
                this.enabled = false;
            } else {
                this.enabled = true;
            }
        }
    }

    public void handle(MongoRequest request, MongoResponse response) throws Exception {
        BsonValue content = request.getContent();
        if (content == null) {
            return;
        }
        if (content.isArray() && request.isPost()) {
            JsonArray passwords = (JsonArray)JsonPath.read((String)BsonUtils.toJson((BsonValue)content), (String)"$.[*].".concat(this.propNamePassword), (Predicate[])new Predicate[0]);
            int[] iarr = new int[]{0};
            passwords.forEach(plain -> {
                if (plain != null && plain.isJsonPrimitive() && plain.getAsJsonPrimitive().isString()) {
                    String hashed = BCrypt.hashpw((String)plain.getAsJsonPrimitive().getAsString(), (String)BCrypt.gensalt((int)this.complexity));
                    content.asArray().get(iarr[0]).asDocument().put(this.propNamePassword, (BsonValue)new BsonString(hashed));
                }
                iarr[0] = iarr[0] + 1;
            });
        } else if (content.isDocument()) {
            try {
                JsonElement plain2 = (JsonElement)JsonPath.read((String)BsonUtils.toJson((BsonValue)content), (String)"$.".concat(this.propNamePassword), (Predicate[])new Predicate[0]);
                if (plain2 != null && plain2.isJsonPrimitive() && plain2.getAsJsonPrimitive().isString()) {
                    String hashed = BCrypt.hashpw((String)plain2.getAsJsonPrimitive().getAsString(), (String)BCrypt.gensalt((int)this.complexity));
                    content.asDocument().put(this.propNamePassword, (BsonValue)new BsonString(hashed));
                }
            }
            catch (PathNotFoundException pnfe) {
                return;
            }
        }
    }

    public boolean resolve(MongoRequest request, MongoResponse response) {
        return this.enabled && request.isHandledBy("mongo") && request.isWriteDocument() && request.isContentTypeJson() && this.usersDb.equalsIgnoreCase(request.getDBName()) && this.usersCollection.equalsIgnoreCase(request.getCollectionName());
    }
}

