/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.mechanisms;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Verification;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.codec.binary.StringUtils;
import org.restheart.configuration.ConfigurationException;
import org.restheart.exchange.Request;
import org.restheart.plugins.ConsumingPlugin;
import org.restheart.plugins.Inject;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.AuthMechanism;
import org.restheart.security.JwtAccount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="jwtAuthenticationMechanism", description="handle JSON Web Token authentication", enabledByDefault=false)
public class JwtAuthenticationMechanism
implements AuthMechanism,
ConsumingPlugin<DecodedJWT> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtAuthenticationMechanism.class);
    public static final String JWT_AUTH_HEADER_PREFIX = "Bearer ";
    private JWTVerifier jwtVerifier;
    private Consumer<DecodedJWT> extraJwtVerifier = null;
    private boolean base64Encoded;
    private String algorithm;
    private String key;
    private String usernameClaim;
    private String rolesClaim;
    private List<String> fixedRoles;
    private String issuer;
    private List<String> audience;
    @Inject(value="config")
    private Map<String, Object> config;

    @OnInit
    public void init() throws ConfigurationException {
        Algorithm _algorithm;
        this.base64Encoded = (Boolean)this.arg(this.config, "base64Encoded");
        this.algorithm = (String)this.arg(this.config, "algorithm");
        this.key = (String)this.arg(this.config, "key");
        if ("secret".equals(this.key)) {
            LOGGER.warn("You should really update the JWT key!");
        }
        this.usernameClaim = (String)this.arg(this.config, "usernameClaim");
        this.rolesClaim = (String)this.argOrDefault(this.config, "rolesClaim", null);
        this.fixedRoles = (List)this.argOrDefault(this.config, "fixedRoles", null);
        this.issuer = (String)this.argOrDefault(this.config, "issuer", null);
        Object _audience = this.argOrDefault(this.config, "audience", null);
        this.audience = new ArrayList<String>();
        if (_audience == null) {
            this.audience = null;
        } else if (_audience instanceof String) {
            String _as = (String)_audience;
            this.audience = new ArrayList<String>();
            this.audience.add(_as);
        } else if (_audience instanceof List) {
            List _al = (List)_audience;
            this.audience = new ArrayList<String>();
            _al.stream().filter(e -> e instanceof String).map(e -> (String)e).forEach(e -> this.audience.add((String)e));
        } else {
            throw new ConfigurationException("Wrong audience, must be a String or an Array of Strings");
        }
        try {
            _algorithm = this.getAlgorithm(this.algorithm, this.key);
        }
        catch (UnsupportedEncodingException | CertificateException ex) {
            throw new ConfigurationException("wrong JWT configuration, cannot setup algorithm", (Throwable)ex);
        }
        Verification v = JWT.require((Algorithm)_algorithm);
        if (this.audience != null && !this.audience.isEmpty()) {
            v = v.withAudience((String[])this.audience.toArray(String[]::new));
        }
        if (this.issuer != null) {
            v = v.withIssuer(this.issuer);
        }
        if (this.rolesClaim != null && this.fixedRoles != null) {
            throw new ConfigurationException("wrong JWT configuration, cannot set both 'rolesClaim' and 'fixedRoles'");
        }
        if (this.rolesClaim == null && (this.fixedRoles == null || this.fixedRoles.isEmpty())) {
            throw new ConfigurationException("wrong JWT configuration, need to set either 'rolesClaim' or 'fixedRoles'");
        }
        this.jwtVerifier = v.build();
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange hse, SecurityContext sc) {
        block13: {
            try {
                LinkedHashSet<String> actualRoles;
                DecodedJWT verifiedJwt;
                String subject;
                block14: {
                    String token = this.getToken(hse);
                    if (token == null) break block13;
                    if (this.base64Encoded) {
                        token = StringUtils.newStringUtf8((byte[])Base64.getUrlDecoder().decode(token));
                    }
                    if ((subject = (verifiedJwt = this.jwtVerifier.verify(token)).getClaim(this.usernameClaim).asString()) == null) {
                        LOGGER.debug("username not specified with claim {}", (Object)this.usernameClaim);
                        sc.authenticationFailed("JwtAuthenticationManager", "username not specified");
                        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                    }
                    actualRoles = new LinkedHashSet<String>();
                    if (this.rolesClaim != null) {
                        Claim _roles = verifiedJwt.getClaim(this.rolesClaim);
                        if (_roles != null && !_roles.isNull()) {
                            try {
                                String[] __roles = (String[])_roles.asArray(String.class);
                                if (__roles != null) {
                                    for (String role : __roles) {
                                        actualRoles.add(role);
                                    }
                                    break block14;
                                }
                                LOGGER.debug("roles is not an array: {}", (Object)_roles.asString());
                                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                            }
                            catch (JWTDecodeException ex) {
                                LOGGER.warn("Jwt cannot get roles from claim {}, extepected an array of strings: {}", (Object)this.rolesClaim, (Object)_roles.toString());
                            }
                        }
                    } else if (this.fixedRoles != null) {
                        actualRoles.addAll(this.fixedRoles);
                    }
                }
                if (this.extraJwtVerifier != null) {
                    this.extraJwtVerifier.accept(verifiedJwt);
                }
                String jwtPayload = new String(Base64.getUrlDecoder().decode(verifiedJwt.getPayload()), Charset.forName("UTF-8"));
                JwtAccount account = new JwtAccount(subject, actualRoles, jwtPayload);
                sc.authenticationComplete((Account)account, "JwtAuthenticationManager", false);
                Request.of((HttpServerExchange)hse).addXForwardedHeader("Jwt-Payload", jwtPayload);
                return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
            }
            catch (JWTVerificationException ex) {
                LOGGER.debug("Jwt not verified: {}", (Object)ex.getMessage());
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(200));
    }

    public void addConsumer(Consumer<DecodedJWT> extraJwtVerifier) {
        this.extraJwtVerifier = extraJwtVerifier;
    }

    private String getToken(HttpServerExchange hse) {
        String authHeader;
        HeaderValues _authHeader = hse.getRequestHeaders().get("Authorization");
        if (_authHeader != null && !_authHeader.isEmpty() && (authHeader = _authHeader.getFirst()).startsWith(JWT_AUTH_HEADER_PREFIX)) {
            return authHeader.substring(7);
        }
        return null;
    }

    private Algorithm getAlgorithm(String name, String key) throws CertificateException, UnsupportedEncodingException {
        if (name == null || key == null) {
            throw new IllegalArgumentException("algorithm and key are required.");
        }
        if (name.startsWith("HMAC") || name.startsWith("HS")) {
            return this.getHMAC(name, key.getBytes("UTF-8"));
        }
        if (name.startsWith("RS")) {
            return this.getRSA(name, key);
        }
        throw new IllegalArgumentException("unknown algorithm " + name);
    }

    private Algorithm getHMAC(String name, byte[] key) throws IllegalArgumentException {
        return switch (name) {
            case "HMAC256", "HS256" -> Algorithm.HMAC256((byte[])key);
            case "HMAC384", "HS384" -> Algorithm.HMAC384((byte[])key);
            case "HMAC512", "HS512" -> Algorithm.HMAC512((byte[])key);
            default -> throw new IllegalArgumentException("unknown HMAC algorithm " + name);
        };
    }

    private Algorithm getRSA(String name, String key) throws IllegalArgumentException, CertificateException {
        RSAPublicKey rsaKey = this.getRSAPublicKey(key);
        return switch (name) {
            case "RSA256", "RS256" -> Algorithm.RSA256((RSAPublicKey)rsaKey, null);
            case "RSA384", "RS384" -> Algorithm.RSA384((RSAPublicKey)rsaKey, null);
            case "RSA512", "RS512" -> Algorithm.RSA512((RSAPublicKey)rsaKey, null);
            default -> throw new IllegalArgumentException("unknown HMAC algorithm " + name);
        };
    }

    private RSAPublicKey getRSAPublicKey(String key) throws CertificateException {
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream is = new ByteArrayInputStream(Base64.getDecoder().decode(key));
        X509Certificate cer = (X509Certificate)fact.generateCertificate(is);
        return (RSAPublicKey)cer.getPublicKey();
    }
}

