/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.services;

import java.util.Map;
import org.restheart.exchange.JsonRequest;
import org.restheart.exchange.JsonResponse;
import org.restheart.exchange.ServiceRequest;
import org.restheart.plugins.Inject;
import org.restheart.plugins.JsonService;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.TokenManager;
import org.restheart.utils.GsonUtils;
import org.restheart.utils.URLUtils;

@RegisterPlugin(name="roles", description="returns the roles of the authenticated client", secure=false, enabledByDefault=true, defaultURI="/roles")
public class GetRoleService
implements JsonService {
    private String myURI = null;
    @Inject(value="config")
    private Map<String, Object> config;

    @OnInit
    public void init() {
        if (this.config == null) {
            this.myURI = "/roles";
        }
        this.myURI = URLUtils.removeTrailingSlashes((String)((String)this.argOrDefault(this.config, "uri", "/roles")));
    }

    public void handle(JsonRequest request, JsonResponse response) throws Exception {
        switch (request.getMethod()) {
            case GET: {
                if (!request.isAuthenticated()) {
                    response.setStatusCode(401);
                    break;
                }
                if (this.checkRequestPath(request)) {
                    GsonUtils.ArrayBuilder roles = GsonUtils.array();
                    request.getAuthenticatedAccount().getRoles().forEach(xva$0 -> roles.add(new String[]{xva$0}));
                    response.setContent(GsonUtils.object().put("authenticated", true).put("roles", roles));
                    break;
                }
                response.setStatusCode(403);
                response.getHeaders().remove(TokenManager.AUTH_TOKEN_HEADER);
                response.getHeaders().remove(TokenManager.AUTH_TOKEN_VALID_HEADER);
                response.getHeaders().remove(TokenManager.AUTH_TOKEN_LOCATION_HEADER);
                break;
            }
            case OPTIONS: {
                this.handleOptions((ServiceRequest)request);
                break;
            }
            default: {
                response.setStatusCode(405);
            }
        }
    }

    private boolean checkRequestPath(JsonRequest request) {
        return request.getAuthenticatedAccount() != null && request.getAuthenticatedAccount().getPrincipal() != null && request.getAuthenticatedAccount().getPrincipal().getName() != null && request.getAuthenticatedAccount().getRoles() != null && request.getPath().equals(this.myURI + "/" + request.getAuthenticatedAccount().getPrincipal().getName());
    }
}

