/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.tokens;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.collect.Sets;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.server.HttpServerExchange;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.restheart.cache.Cache;
import org.restheart.cache.CacheFactory;
import org.restheart.cache.LoadingCache;
import org.restheart.configuration.ConfigurationException;
import org.restheart.configuration.Utils;
import org.restheart.exchange.Request;
import org.restheart.plugins.Inject;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.TokenManager;
import org.restheart.security.BaseAccount;
import org.restheart.security.JwtAccount;
import org.restheart.security.PwdCredentialAccount;
import org.restheart.security.WithProperties;
import org.restheart.security.tokens.ComparableAccount;
import org.restheart.security.tokens.Token;
import org.restheart.utils.Pair;
import org.restheart.utils.URLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="jwtTokenManager", description="issues and verifies auth tokens in a cluster compatible way", enabledByDefault=false)
public class JwtTokenManager
implements TokenManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtTokenManager.class);
    private LoadingCache<ComparableAccount, Token> jwtCache;
    private JWTVerifier verifier;
    private Algorithm algo;
    private String srvURI = "/tokens";
    private int ttl = 15;
    private String issuer = "restheart.org";
    private String[] audience;
    private static final int MAX_CACHE_SIZE = 1000;
    private boolean enabled = false;
    private List<String> accountPropertiesClaims;
    @Inject(value="config")
    Map<String, Object> config;

    @OnInit
    public void init() throws ConfigurationException {
        this.enabled = true;
        this.srvURI = (String)this.arg(this.config, "srv-uri");
        this.ttl = (Integer)this.arg(this.config, "ttl");
        if (this.ttl < 1) {
            this.enabled = false;
            throw new ConfigurationException("TTL minimum value is 1 minute");
        }
        String key = (String)this.arg(this.config, "key");
        if ("secret".equals(key)) {
            LOGGER.warn("You should really update the JWT key!");
        }
        this.algo = Algorithm.HMAC256((String)((String)this.arg(this.config, "key")));
        this.issuer = (String)this.arg(this.config, "issuer");
        this.jwtCache = CacheFactory.createLocalLoadingCache((long)1000L, (Cache.EXPIRE_POLICY)Cache.EXPIRE_POLICY.AFTER_WRITE, (long)(this.ttl * 1000 * 60 - 500), account -> this.newToken(account.wrapped));
        this.audience = (String[])this.argOrDefault(this.config, "audience", null);
        try {
            this.verifier = this.audience != null ? JWT.require((Algorithm)this.algo).withIssuer(this.issuer).withAudience(this.audience).build() : JWT.require((Algorithm)this.algo).withIssuer(this.issuer).build();
        }
        catch (Throwable t) {
            this.enabled = false;
            LOGGER.error("error", t);
            throw new ConfigurationException("error ");
        }
        this.accountPropertiesClaims = (List)this.argOrDefault(this.config, "account-properties-claims", null);
    }

    public Account verify(Account account) {
        return this.enabled ? account : null;
    }

    public Account verify(String id, Credential credential) {
        if (!this.enabled) {
            return null;
        }
        if (id != null && credential instanceof PasswordCredential) {
            char[] rawToken = ((PasswordCredential)credential).getPassword();
            ComparableAccount ca = new ComparableAccount((Account)new BaseAccount(id, null));
            Optional _cached = this.jwtCache.get((Object)ca);
            if (_cached != null && _cached.isPresent() && Arrays.equals(rawToken, ((Token)_cached.get()).raw())) {
                LOGGER.debug("jwt token in cache");
                Token cached = (Token)_cached.get();
                HashSet roles = Sets.newHashSet((Object[])cached.roles());
                String[] jwtParts = new String(cached.raw()).split("\\.");
                String jwtPayload = new String(Base64.getUrlDecoder().decode(jwtParts[1]), Charset.forName("UTF-8"));
                return new JwtAccount(id, (Set)roles, jwtPayload);
            }
            LOGGER.trace("jwt token not in cache, let's verify it");
            try {
                DecodedJWT decoded = this.verifier.verify(new String(rawToken));
                if (id.equals(decoded.getSubject())) {
                    Object[] _roles = (String[])decoded.getClaim("roles").asArray(String.class);
                    HashSet roles = Sets.newHashSet((Object[])_roles);
                    String jwtPayload = new String(Base64.getUrlDecoder().decode(decoded.getPayload()), Charset.forName("UTF-8"));
                    this.jwtCache.put((Object)ca, (Object)this.newToken(ca.wrapped, decoded.getExpiresAt()));
                    return new JwtAccount(id, (Set)roles, jwtPayload);
                }
                LOGGER.warn("invalid token from user {}, not matching id in token, was {}", (Object)id, (Object)decoded.getSubject());
                return null;
            }
            catch (Throwable t) {
                LOGGER.debug("expired or invalid token from user {}, {}", (Object)id, (Object)t.getMessage());
                return null;
            }
        }
        return null;
    }

    public Account verify(Credential credential) {
        return null;
    }

    public PasswordCredential get(Account account) {
        if (!this.enabled) {
            return null;
        }
        if (account == null || account.getPrincipal() == null || account.getPrincipal().getName() == null) {
            return null;
        }
        Token token = (Token)this.jwtCache.getLoading((Object)new ComparableAccount(account)).get();
        PwdCredentialAccount newTokenAccount = new PwdCredentialAccount(account.getPrincipal().getName(), token.raw(), (Set)Sets.newTreeSet((Iterable)account.getRoles()));
        return newTokenAccount.getCredentials();
    }

    private Token newToken(Account account) {
        return this.newToken(account, Date.from(Instant.now().plus((long)this.ttl, ChronoUnit.MINUTES)));
    }

    private Token newToken(Account account, Date expires) {
        Map<String, ? super Object> properties;
        JWTCreator.Builder creator = this.audience != null ? JWT.create().withIssuer(this.issuer).withAudience(this.audience) : JWT.create().withIssuer(this.issuer);
        JWTCreator.Builder _builder = creator.withSubject(account.getPrincipal().getName()).withExpiresAt(expires).withIssuer(this.issuer).withArrayClaim("roles", account.getRoles().toArray(new String[account.getRoles().size()]));
        JWTCreator.Builder[] builder = new JWTCreator.Builder[]{_builder};
        if (account instanceof WithProperties) {
            WithProperties awp = (WithProperties)account;
            properties = this.claimsFromAccountProps(awp.propertiesAsMap());
            properties.entrySet().stream().forEach(e -> {
                builder[0] = this.withClaim(builder[0], (String)e.getKey(), e.getValue());
            });
        } else {
            properties = null;
        }
        String raw = builder[0].sign(this.algo);
        return new Token(raw.toCharArray(), expires, account.getRoles().toArray(new String[0]), properties);
    }

    private JWTCreator.Builder withClaim(JWTCreator.Builder b, String k, Object v) {
        if (k == null || v == null) {
            return b;
        }
        if (v instanceof String) {
            String s = (String)v;
            return b.withClaim(k, s);
        }
        if (v instanceof String[]) {
            String[] ss = (String[])v;
            return b.withArrayClaim(k, ss);
        }
        if (v instanceof Boolean) {
            Boolean boo = (Boolean)v;
            return b.withClaim(k, boo);
        }
        if (v instanceof Integer) {
            Integer i = (Integer)v;
            return b.withClaim(k, i);
        }
        if (v instanceof Integer[]) {
            Integer[] ii = (Integer[])v;
            return b.withArrayClaim(k, ii);
        }
        if (v instanceof Long) {
            Long l = (Long)v;
            return b.withClaim(k, l);
        }
        if (v instanceof Long[]) {
            Long[] ll = (Long[])v;
            return b.withArrayClaim(k, ll);
        }
        if (v instanceof Double) {
            Double d = (Double)v;
            return b.withClaim(k, d);
        }
        if (v instanceof Date) {
            Date d = (Date)v;
            return b.withClaim(k, d);
        }
        if (v instanceof Map) {
            Map m = (Map)v;
            try {
                return b.withClaim(k, m);
            }
            catch (ClassCastException cce) {
                LOGGER.warn("cannot add claim {} to jwt because of usupported type", (Object)k);
                return b;
            }
        }
        if (v instanceof List) {
            List l = (List)v;
            return b.withClaim(k, l);
        }
        LOGGER.warn("cannot add claim {} to jwt because of usupported type", (Object)k, (Object)v.getClass().getSimpleName());
        return b;
    }

    private Map<String, ? super Object> claimsFromAccountProps(Map<String, ? super Object> properties) {
        HashMap ret = new HashMap();
        if (this.accountPropertiesClaims != null) {
            this.accountPropertiesClaims.stream().map(path -> new Pair((Object)this.keysFromPath((String)path), Utils.find((Map)properties, (String)path, (boolean)true))).filter(p -> p.getValue() != null).forEach(p -> this.addClaim(ret, (String[])p.getKey(), p.getValue()));
        }
        return ret;
    }

    private String[] keysFromPath(String path) {
        String[] stringArray;
        if (path.contains("/")) {
            stringArray = path.split("/");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = path;
        }
        String[] ret = stringArray;
        return (String[])Arrays.stream(ret).filter(k -> k != null && !k.isBlank()).toArray(String[]::new);
    }

    private void addClaim(Map<String, Object> map, String[] keys, Object val) {
        for (int idx = 0; idx < keys.length; ++idx) {
            if (idx != keys.length - 1) {
                HashMap<String, Object> nestedMap = new HashMap<String, Object>();
                map.put(keys[idx], nestedMap);
                this.addClaim(nestedMap, Arrays.copyOfRange(keys, idx + 1, keys.length), val);
                break;
            }
            map.put(keys[idx], val);
        }
    }

    public void invalidate(Account account) {
        if (!this.enabled) {
            return;
        }
        this.jwtCache.invalidate((Object)new ComparableAccount(account));
    }

    public void update(Account account) {
        if (!this.enabled) {
            return;
        }
        ComparableAccount ca = new ComparableAccount(account);
        this.jwtCache.put((Object)ca, (Object)((Token)this.jwtCache.getLoading((Object)ca).get()));
    }

    public void injectTokenHeaders(HttpServerExchange exchange, PasswordCredential token) {
        if (!this.enabled) {
            return;
        }
        Request request = Request.of((HttpServerExchange)exchange);
        if (request.getAuthenticatedAccount() != null && request.getAuthenticatedAccount().getPrincipal() != null && request.getAuthenticatedAccount().getPrincipal().getName() != null) {
            Account account = request.getAuthenticatedAccount();
            ComparableAccount ca = new ComparableAccount(account);
            String cid = request.getAuthenticatedAccount().getPrincipal().getName();
            exchange.getResponseHeaders().add(AUTH_TOKEN_LOCATION_HEADER, URLUtils.removeTrailingSlashes((String)this.srvURI).concat("/").concat(cid));
            if (exchange.getQueryParameters().containsKey("renew-auth-token")) {
                Token newToken = this.newToken(account);
                this.jwtCache.put((Object)ca, (Object)newToken);
                exchange.getResponseHeaders().add(AUTH_TOKEN_HEADER, new String(newToken.raw()));
                exchange.getResponseHeaders().add(AUTH_TOKEN_VALID_HEADER, newToken.getDateAsString());
            } else if (this.jwtCache.get((Object)ca) != null) {
                Token cachedToken = (Token)this.jwtCache.get((Object)ca).get();
                exchange.getResponseHeaders().add(AUTH_TOKEN_HEADER, new String(cachedToken.raw()));
                exchange.getResponseHeaders().add(AUTH_TOKEN_VALID_HEADER, cachedToken.getDateAsString());
            }
        }
    }
}

