/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.predicates;

import com.google.common.collect.Sets;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class QParamsWhitelistPredicate
implements Predicate {
    private final Set<String> whitelist;

    public QParamsWhitelistPredicate(String[] whitelist) {
        this.whitelist = whitelist == null ? Sets.newHashSet() : Sets.newHashSet((Object[])whitelist);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean resolve(HttpServerExchange exchange) {
        Map qparamsInExchange = exchange.getQueryParameters();
        if (this.whitelist.isEmpty()) {
            return qparamsInExchange.isEmpty();
        }
        if (qparamsInExchange == null) return true;
        if (!qparamsInExchange.keySet().stream().allMatch(this.whitelist::contains)) return false;
        return true;
    }

    public static class Builder
    implements PredicateBuilder {
        public String name() {
            return "qparams-whitelist";
        }

        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("whitelist", String[].class);
        }

        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        public String defaultParameter() {
            return "whitelist";
        }

        public Predicate build(Map<String, Object> config) {
            return new QParamsWhitelistPredicate((String[])config.get("whitelist"));
        }
    }
}

