/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.tokens;

import com.google.common.collect.Sets;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.server.HttpServerExchange;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.restheart.cache.Cache;
import org.restheart.cache.CacheFactory;
import org.restheart.configuration.ConfigurationException;
import org.restheart.exchange.JsonProxyRequest;
import org.restheart.plugins.Inject;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.TokenManager;
import org.restheart.security.FileRealmAccount;
import org.restheart.security.JwtAccount;
import org.restheart.security.MongoRealmAccount;
import org.restheart.security.PwdCredentialAccount;
import org.restheart.utils.BsonUtils;
import org.restheart.utils.URLUtils;

@RegisterPlugin(name="rndTokenManager", description="generates random auth tokens", enabledByDefault=false)
public class RndTokenManager
implements TokenManager {
    private static final SecureRandom RND_GENERATOR = new SecureRandom();
    private static Cache<String, PwdCredentialAccount> CACHE = null;
    private int ttl = -1;
    private String srvURI = null;
    @Inject(value="config")
    private Map<String, Object> config;

    @OnInit
    public void init() throws ConfigurationException {
        this.ttl = (Integer)this.arg(this.config, "ttl");
        this.srvURI = (String)this.arg(this.config, "srv-uri");
        CACHE = CacheFactory.createLocalCache((long)Long.MAX_VALUE, (Cache.EXPIRE_POLICY)Cache.EXPIRE_POLICY.AFTER_READ, (long)(this.ttl * 60 * 1000));
    }

    public Account verify(Account account) {
        return account;
    }

    public Account verify(String id, Credential credential) {
        Optional _account = CACHE.get((Object)id);
        return _account != null && _account.isPresent() && this.verifyToken((PwdCredentialAccount)_account.get(), credential) ? (Account)_account.get() : null;
    }

    public Account verify(Credential credential) {
        return null;
    }

    private boolean verifyToken(PwdCredentialAccount account, Credential credential) {
        if (credential instanceof PasswordCredential) {
            char[] token = ((PasswordCredential)credential).getPassword();
            char[] expectedToken = account.getCredentials().getPassword();
            return Arrays.equals(token, expectedToken);
        }
        return false;
    }

    public Cache<String, PwdCredentialAccount> getCACHE() {
        return CACHE;
    }

    public PasswordCredential get(Account account) {
        Optional cachedAccount = CACHE.get((Object)account.getPrincipal().getName());
        if (cachedAccount != null && cachedAccount.isPresent()) {
            return ((PwdCredentialAccount)cachedAccount.get()).getCredentials();
        }
        PwdCredentialAccount newCachedTokenAccount = this.cloneWithToken(account, RndTokenManager.nextToken());
        CACHE.put((Object)account.getPrincipal().getName(), (Object)newCachedTokenAccount);
        return newCachedTokenAccount.getCredentials();
    }

    private PwdCredentialAccount cloneWithToken(Account account, char[] token) {
        MongoRealmAccount ret;
        if (account instanceof MongoRealmAccount) {
            MongoRealmAccount maccount = (MongoRealmAccount)account;
            ret = new MongoRealmAccount(maccount.getPrincipal().getName(), token, (Set)Sets.newTreeSet((Iterable)maccount.getRoles()), maccount.properties());
        } else if (account instanceof FileRealmAccount) {
            FileRealmAccount faccount = (FileRealmAccount)account;
            ret = new FileRealmAccount(faccount.getPrincipal().getName(), token, (Set)Sets.newTreeSet((Iterable)faccount.getRoles()), faccount.properties());
        } else if (account instanceof JwtAccount) {
            JwtAccount jwtAccount = (JwtAccount)account;
            BsonValue accountDocument = BsonUtils.parse((String)jwtAccount.properties());
            if (accountDocument instanceof BsonDocument) {
                BsonDocument bad = (BsonDocument)accountDocument;
                ret = new MongoRealmAccount(jwtAccount.getPrincipal().getName(), token, (Set)Sets.newTreeSet((Iterable)jwtAccount.getRoles()), bad);
            } else {
                ret = new PwdCredentialAccount(jwtAccount.getPrincipal().getName(), token, (Set)Sets.newTreeSet((Iterable)jwtAccount.getRoles()));
            }
        } else {
            ret = new PwdCredentialAccount(account.getPrincipal().getName(), token, (Set)Sets.newTreeSet((Iterable)account.getRoles()));
        }
        return ret;
    }

    public void invalidate(Account account) {
        CACHE.invalidate((Object)account.getPrincipal().getName());
    }

    public void update(Account account) {
        String id = account.getPrincipal().getName();
        Optional _authTokenAccount = CACHE.get((Object)id);
        if (_authTokenAccount != null && _authTokenAccount.isPresent()) {
            PwdCredentialAccount authTokenAccount = (PwdCredentialAccount)_authTokenAccount.get();
            PwdCredentialAccount updatedAuthTokenAccount = this.cloneWithToken(account, authTokenAccount.getCredentials().getPassword());
            CACHE.put((Object)id, (Object)updatedAuthTokenAccount);
        }
    }

    public void injectTokenHeaders(HttpServerExchange exchange, PasswordCredential token) {
        exchange.getResponseHeaders().add(AUTH_TOKEN_HEADER, new String(token.getPassword()));
        exchange.getResponseHeaders().add(AUTH_TOKEN_VALID_HEADER, Instant.now().plus((long)this.ttl, ChronoUnit.MINUTES).toString());
        JsonProxyRequest request = JsonProxyRequest.of((HttpServerExchange)exchange);
        if (request.getAuthenticatedAccount() != null && request.getAuthenticatedAccount().getPrincipal() != null && request.getAuthenticatedAccount().getPrincipal().getName() != null) {
            String cid = request.getAuthenticatedAccount().getPrincipal().getName();
            exchange.getResponseHeaders().add(AUTH_TOKEN_LOCATION_HEADER, URLUtils.removeTrailingSlashes((String)this.srvURI).concat("/").concat(cid));
        }
    }

    private static char[] nextToken() {
        return new BigInteger(256, RND_GENERATOR).toString(36).toCharArray();
    }
}

