/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.authorizers;

import java.util.Optional;
import java.util.function.Predicate;
import org.restheart.exchange.Request;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.Authorizer;
import org.restheart.security.authorizers.ACLRegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="aclRegistryAllower", description="allow requests according to allow predicates defined in the ACLRegistry", enabledByDefault=true, authorizerType=Authorizer.TYPE.ALLOWER)
public class ACLRegistryAllower
implements Authorizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ACLRegistryAllower.class);
    private final ACLRegistryImpl registry = ACLRegistryImpl.getInstance();

    public boolean isAllowed(Request<?> request) {
        Optional<Predicate> allowPredicate = this.registry.allowPredicates().stream().filter(predicate -> predicate.test(request)).findFirst();
        LOGGER.debug("request authorized by ACLRegistryAllower? {}", (Object)allowPredicate.isPresent());
        return allowPredicate.isPresent();
    }

    public boolean isAuthenticationRequired(Request<?> request) {
        return this.registry.authenticationRequirements().isEmpty() || this.registry.authenticationRequirements().stream().allMatch(predicate -> predicate.test(request));
    }
}

