/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.authorizers;

import org.restheart.exchange.Request;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.Authorizer;
import org.restheart.security.authorizers.ACLRegistryImpl;

@RegisterPlugin(name="aclRegistryVetoer", description="vetoes requests according to veto predicates defined in the ACLRegistry", enabledByDefault=true, authorizerType=Authorizer.TYPE.VETOER)
public class ACLRegistryVetoer
implements Authorizer {
    private final ACLRegistryImpl registry = ACLRegistryImpl.getInstance();

    public boolean isAllowed(Request<?> request) {
        return this.registry.vetoPredicates().stream().allMatch(predicate -> !predicate.test(request));
    }

    public boolean isAuthenticationRequired(Request<?> request) {
        return false;
    }
}

