/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.predicates;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.restheart.exchange.BsonRequest;
import org.restheart.exchange.Request;
import org.restheart.utils.BsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BsonRequestPropEqualsPredicate
implements Predicate {
    private static final Logger LOGGER = LoggerFactory.getLogger(BsonRequestPropEqualsPredicate.class);
    private final String key;
    private final ExchangeAttribute value;

    public BsonRequestPropEqualsPredicate(String key, ExchangeAttribute value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("bson-request-prop-equals predicate must specify key and value");
        }
        this.key = key;
        this.value = value;
    }

    public boolean resolve(HttpServerExchange exchange) {
        Request _request = Request.of((HttpServerExchange)exchange);
        if (_request == null) {
            LOGGER.warn("bson-request-prop-equals predicate invkoed on null BsonRequest");
            return false;
        }
        if (_request instanceof BsonRequest) {
            BsonRequest bsonRequest = (BsonRequest)_request;
            if (bsonRequest.getContent() == null) {
                LOGGER.warn("bson-request-prop-equals predicate invoked on a BsonRequest with null content");
                return false;
            }
            Object object = bsonRequest.getContent();
            if (object instanceof BsonDocument) {
                BsonDocument contentDoc = (BsonDocument)object;
                Optional _value = BsonUtils.get((BsonDocument)contentDoc, (String)this.key);
                if (_value.isPresent()) {
                    BsonValue expected = BsonUtils.parse((String)this.value.readAttribute(exchange));
                    return ((BsonValue)_value.get()).equals(expected);
                }
                return false;
            }
            LOGGER.warn("bson-request-prop-equals predicate invoked on a BsonRequest with content {}, it requires a BsonDocument", (Object)((BsonValue)bsonRequest.getContent()).getClass().getSimpleName());
            return false;
        }
        LOGGER.warn("bson-request-prop-equals predicate not invoked on a BsonRequest");
        return false;
    }

    public static class Builder
    implements PredicateBuilder {
        public String name() {
            return "bson-request-prop-equals";
        }

        public Map<String, Class<?>> parameters() {
            HashMap params = Maps.newHashMap();
            params.put("key", String.class);
            params.put("value", ExchangeAttribute.class);
            return params;
        }

        public Set<String> requiredParameters() {
            return Sets.newHashSet((Object[])new String[]{"key", "value"});
        }

        public String defaultParameter() {
            return "key";
        }

        public Predicate build(Map<String, Object> config) {
            return new BsonRequestPropEqualsPredicate((String)config.get("key"), (ExchangeAttribute)config.get("value"));
        }
    }
}

