/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.predicates;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.restheart.exchange.BsonRequest;
import org.restheart.exchange.Request;
import org.restheart.security.predicates.BsonRequestArrayIsSubsetPredicate;
import org.restheart.utils.BsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BsonRequestArrayContainsPredicate
implements Predicate {
    private static final Logger LOGGER = LoggerFactory.getLogger(BsonRequestArrayIsSubsetPredicate.class);
    private final String key;
    private final BsonArray values;

    public BsonRequestArrayContainsPredicate(String key, String[] values) {
        if (key == null || values == null) {
            throw new IllegalArgumentException("bson-request-array-contains predicate must specify key and values");
        }
        this.key = key;
        this.values = new BsonArray();
        for (String value : values) {
            try {
                this.values.add(BsonUtils.parse((String)value));
            }
            catch (Throwable t) {
                throw new IllegalArgumentException(value + " is not a valid bson value");
            }
        }
    }

    public boolean resolve(HttpServerExchange exchange) {
        Request _request = Request.of((HttpServerExchange)exchange);
        if (_request == null) {
            LOGGER.warn("bson-request-array-contains predicate invkoed on null BsonRequest");
            return false;
        }
        if (_request instanceof BsonRequest) {
            BsonRequest bsonRequest = (BsonRequest)_request;
            if (bsonRequest.getContent() == null) {
                LOGGER.warn("bson-request-array-contains predicate invoked on a BsonRequest with null content");
                return false;
            }
            Object object = bsonRequest.getContent();
            if (object instanceof BsonDocument) {
                BsonDocument contentDoc = (BsonDocument)object;
                Optional _values = BsonUtils.get((BsonDocument)contentDoc, (String)this.key);
                if (_values.isPresent()) {
                    BsonValue values = (BsonValue)_values.get();
                    if (values.isArray()) {
                        return values.asArray().containsAll((Collection)this.values);
                    }
                    return false;
                }
                return false;
            }
            LOGGER.warn("bson-request-array-contains predicate invoked on a BsonRequest with content {}, it requires a BsonDocument", (Object)((BsonValue)bsonRequest.getContent()).getClass().getSimpleName());
            return false;
        }
        LOGGER.warn("bson-request-array-contains predicate not invoked on a BsonRequest");
        return false;
    }

    public static class Builder
    implements PredicateBuilder {
        public String name() {
            return "bson-request-array-contains";
        }

        public Map<String, Class<?>> parameters() {
            HashMap params = Maps.newHashMap();
            params.put("key", String.class);
            params.put("values", String[].class);
            return params;
        }

        public Set<String> requiredParameters() {
            return Sets.newHashSet((Object[])new String[]{"key", "values"});
        }

        public String defaultParameter() {
            return "key";
        }

        public Predicate build(Map<String, Object> config) {
            return new BsonRequestArrayContainsPredicate((String)config.get("key"), (String[])config.get("values"));
        }
    }
}

