/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.utils;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.restheart.utils.BsonUtils;

public class MongoUtils {
    MongoClient client;

    public MongoUtils(MongoClient client) {
        this.client = client;
    }

    public boolean doesDbExist(String dbName) {
        return this.client.getDatabase(dbName).listCollectionNames().first() != null;
    }

    public boolean doesCollectionExist(String dbName, String collName) {
        for (String dbCollection : this.client.getDatabase(dbName).listCollectionNames()) {
            if (!collName.equals(dbCollection)) continue;
            return true;
        }
        return false;
    }

    public void createDb(String dbName) {
        this.client.getDatabase(dbName).createCollection("_properties");
        MongoCollection pc = this.client.getDatabase(dbName).getCollection("_properties", BsonDocument.class);
        pc.insertOne((Object)BsonUtils.document().put("_id", (BsonValue)new BsonString("_properties")).put("_etag", (BsonValue)new BsonObjectId()).get());
    }

    public void createCollection(String dbName, String collName) {
        MongoCollection pc = this.client.getDatabase(dbName).getCollection("_properties", BsonDocument.class);
        pc.insertOne((Object)BsonUtils.document().put("_id", (BsonValue)new BsonString("_properties.".concat(collName))).put("_etag", (BsonValue)new BsonObjectId()).get());
        this.client.getDatabase(dbName).createCollection(collName);
    }
}

