/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.authorizers;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.restheart.exchange.Request;
import org.restheart.security.ACLRegistry;

public class ACLRegistryImpl
implements ACLRegistry {
    private static final ACLRegistryImpl HOLDER = new ACLRegistryImpl();
    private final Set<Predicate<Request<?>>> vetoPredicates = new LinkedHashSet();
    private final Set<Predicate<Request<?>>> allowPredicates = new LinkedHashSet();
    private final Set<Predicate<Request<?>>> authenticationRequirements = new LinkedHashSet();

    private ACLRegistryImpl() {
    }

    static ACLRegistryImpl getInstance() {
        return HOLDER;
    }

    public void registerVeto(Predicate<Request<?>> veto) {
        this.vetoPredicates.add(veto);
    }

    public void registerAllow(Predicate<Request<?>> allow) {
        this.allowPredicates.add(allow);
    }

    public void registerAuthenticationRequirement(Predicate<Request<?>> authenticationRequired) {
        this.authenticationRequirements.add(authenticationRequired);
    }

    Set<Predicate<Request<?>>> vetoPredicates() {
        return this.vetoPredicates;
    }

    Set<Predicate<Request<?>>> allowPredicates() {
        return this.allowPredicates;
    }

    Set<Predicate<Request<?>>> authenticationRequirements() {
        return this.authenticationRequirements;
    }
}

