/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.authenticators;

import com.google.common.collect.Sets;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.DigestCredential;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.util.HexConverter;
import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.restheart.configuration.ConfigurationException;
import org.restheart.plugins.FileConfigurablePlugin;
import org.restheart.plugins.Inject;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.Authenticator;
import org.restheart.security.FileRealmAccount;
import org.restheart.utils.LambdaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="fileRealmAuthenticator", description="authenticates clients credentials defined in a configuration file", enabledByDefault=false)
public class FileRealmAuthenticator
extends FileConfigurablePlugin
implements Authenticator {
    private static final String USERS = "users";
    private static final Logger LOGGER = LoggerFactory.getLogger(FileRealmAuthenticator.class);
    private final Map<String, FileRealmAccount> accounts = new HashMap<String, FileRealmAccount>();
    @Inject(value="config")
    private Map<String, Object> config;

    @OnInit
    public void init() throws FileNotFoundException, ConfigurationException {
        if (this.config.containsKey("conf-file") && this.config.get("conf-file") != null) {
            this.init(this.config, USERS);
        } else if (this.config.containsKey(USERS) && this.config.get(USERS) != null) {
            List users = (List)this.argOrDefault(this.config, USERS, new ArrayList());
            users.stream().forEach(this.consumeConfiguration());
        } else {
            throw new IllegalArgumentException("The configuration requires either 'conf-file' or 'users' paramenter");
        }
    }

    public Consumer<? super Map<String, Object>> consumeConfiguration() {
        return u -> {
            try {
                String userid = (String)this.arg((Map)u, "userid");
                String _password = (String)this.arg((Map)u, "password");
                if (_password == null) {
                    LOGGER.warn("User {} has a null password, disabling it. You can set it with the environment variable RHO=\"/fileRealmAuthenticator/users[userid='admin']/password->'secret'\"", (Object)userid);
                    return;
                }
                char[] password = _password.toCharArray();
                List _roles = (List)this.arg((Map)u, "roles");
                if (_roles.stream().anyMatch(i -> !(i instanceof String))) {
                    throw new IllegalArgumentException("wrong configuration. a roles entry is wrong. they all must be strings");
                }
                LinkedHashSet roles = Sets.newLinkedHashSet((Iterable)_roles);
                u.remove("password");
                FileRealmAccount a = new FileRealmAccount(userid, password, (Set)roles, u);
                this.accounts.put(userid, a);
            }
            catch (ConfigurationException pce) {
                LambdaUtils.throwsSneakyException((Throwable)pce);
            }
        };
    }

    public Account verify(Account account) {
        return account;
    }

    public Account verify(String id, Credential credential) {
        Account account = (Account)this.accounts.get(id);
        return account != null && this.verifyCredential(account, credential) ? account : null;
    }

    public Account verify(Credential credential) {
        return null;
    }

    private boolean verifyCredential(Account account, Credential credential) {
        if (account instanceof FileRealmAccount) {
            if (credential instanceof PasswordCredential) {
                return this.verifyPasswordCredential(account, credential);
            }
            if (credential instanceof DigestCredential) {
                return this.verifyDigestCredential(account, credential);
            }
        }
        return false;
    }

    private boolean verifyPasswordCredential(Account account, Credential credential) {
        char[] password = ((PasswordCredential)credential).getPassword();
        char[] expectedPassword = this.accounts.get(account.getPrincipal().getName()).getCredentials().getPassword();
        return Arrays.equals(password, expectedPassword);
    }

    private boolean verifyDigestCredential(Account account, Credential credential) {
        try {
            DigestCredential dc = (DigestCredential)credential;
            MessageDigest digest = dc.getAlgorithm().getMessageDigest();
            char[] expectedPassword = this.accounts.get(account.getPrincipal().getName()).getCredentials().getPassword();
            digest.update(account.getPrincipal().getName().getBytes(StandardCharsets.UTF_8));
            digest.update((byte)58);
            digest.update(dc.getRealm().getBytes(StandardCharsets.UTF_8));
            digest.update((byte)58);
            digest.update(new String(expectedPassword).getBytes(StandardCharsets.UTF_8));
            byte[] ha1 = HexConverter.convertToHexBytes((byte[])digest.digest());
            return dc.verifyHA1(ha1);
        }
        catch (NoSuchAlgorithmException ne) {
            return false;
        }
    }
}

