/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.predicates;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class QParamsSizePredicate
implements Predicate {
    private final int size;

    public QParamsSizePredicate(int size) {
        this.size = size;
    }

    public boolean resolve(HttpServerExchange exchange) {
        Map qparamsInExchange = exchange.getQueryParameters();
        return qparamsInExchange == null && this.size == 0 || qparamsInExchange != null && qparamsInExchange.keySet().size() == this.size;
    }

    public static class Builder
    implements PredicateBuilder {
        public String name() {
            return "qparams-size";
        }

        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("size", Integer.class);
        }

        public Set<String> requiredParameters() {
            return Collections.singleton("size");
        }

        public String defaultParameter() {
            return "size";
        }

        public Predicate build(Map<String, Object> config) {
            return new QParamsSizePredicate((Integer)config.get("size"));
        }
    }
}

