/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.authenticators;

import io.undertow.server.handlers.CookieImpl;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import org.restheart.exchange.ServiceRequest;
import org.restheart.exchange.ServiceResponse;
import org.restheart.plugins.Inject;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.WildcardInterceptor;
import org.restheart.security.authenticators.AuthCookieHandler;

@RegisterPlugin(name="authCookieSetter", description="sets the auth cookie if the URL contains the qparam ?set-auth-cookie", interceptPoint=InterceptPoint.RESPONSE)
public class AuthCookieSetter
implements WildcardInterceptor {
    @Inject(value="config")
    private Map<String, Object> config;
    @Inject(value="registry")
    PluginsRegistry pluginsRegistry;
    private boolean enabled = true;
    private boolean jwtAuthWithJwtAuthMechanism = false;
    private String name;
    private String domain;
    private String path;
    private boolean secure;
    private boolean httpOnly;
    private boolean sameSite;
    private String sameSiteMode;
    private int secondsUntilExpiration;

    @OnInit
    public void init() {
        this.enabled = AuthCookieHandler.enabled(this.pluginsRegistry, true);
        this.jwtAuthWithJwtAuthMechanism = this.pluginsRegistry.getTokenManager() != null && "jwtTokenManager".equals(this.pluginsRegistry.getTokenManager().getName()) && this.pluginsRegistry.getAuthMechanisms().stream().map(pr -> pr.getName()).anyMatch(n -> "jwtAuthenticationMechanism".equals(n));
        this.name = (String)this.argOrDefault(this.config, "name", "rh_auth");
        this.secure = (Boolean)this.argOrDefault(this.config, "secure", true);
        this.domain = (String)this.argOrDefault(this.config, "domain", "localhost");
        this.path = (String)this.argOrDefault(this.config, "path", "/");
        this.httpOnly = (Boolean)this.argOrDefault(this.config, "http-only", true);
        this.sameSite = (Boolean)this.argOrDefault(this.config, "same-site", true);
        this.sameSiteMode = (String)this.argOrDefault(this.config, "same-site-mode", "strict");
        this.secondsUntilExpiration = (Integer)this.argOrDefault(this.config, "expires-ttl", 86400);
    }

    public void handle(ServiceRequest<?> req, ServiceResponse<?> res) throws Exception {
        String authToken;
        String authTokenHeader = res.getHeader("Auth-Token");
        String string = authToken = this.jwtAuthWithJwtAuthMechanism ? "Bearer ".concat(authTokenHeader) : "Basic ".concat(Base64.getEncoder().encodeToString((req.getAuthenticatedAccount().getPrincipal().getName() + ":" + authTokenHeader).getBytes()));
        if (authToken != null) {
            Instant expiry = LocalDateTime.now().plusSeconds(this.secondsUntilExpiration).toInstant(ZoneOffset.UTC);
            res.getExchange().setResponseCookie(new CookieImpl(this.name, authToken).setSecure(this.secure).setHttpOnly(this.httpOnly).setDomain(this.domain).setPath(this.path).setSameSite(this.sameSite).setSameSiteMode(this.sameSiteMode).setExpires(Date.from(expiry)));
        }
    }

    public boolean resolve(ServiceRequest<?> req, ServiceResponse<?> res) {
        return this.enabled && !req.isOptions() && req.isAuthenticated() && req.getQueryParameters().containsKey("set-auth-cookie") && res.getHeader("Auth-Token") != null;
    }
}

