/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.services;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.restheart.exchange.JsonRequest;
import org.restheart.exchange.JsonResponse;
import org.restheart.exchange.ServiceRequest;
import org.restheart.plugins.Inject;
import org.restheart.plugins.JsonService;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.security.ACLRegistry;
import org.restheart.utils.GsonUtils;
import org.restheart.utils.URLUtils;

@RegisterPlugin(name="roles", description="returns the roles of the authenticated client", secure=true, enabledByDefault=true, defaultURI="/roles")
public class GetRoleService
implements JsonService {
    private String myURI = null;
    @Inject(value="config")
    private Map<String, Object> config;
    @Inject(value="acl-registry")
    private ACLRegistry aclRegistry;

    @OnInit
    public void init() {
        if (this.config == null) {
            this.myURI = "/roles";
        }
        this.myURI = URLUtils.removeTrailingSlashes((String)((String)this.argOrDefault(this.config, "uri", "/roles")));
        this.aclRegistry.registerAllow(req -> req.isAuthenticated() && req.getPath().equals(this.myURI + "/" + req.getAuthenticatedAccount().getPrincipal().getName()));
        this.aclRegistry.registerVeto(req -> req.getPath().startsWith(this.myURI) && (!req.isAuthenticated() || !req.getPath().equals(this.myURI + "/" + req.getAuthenticatedAccount().getPrincipal().getName())));
    }

    public void handle(JsonRequest request, JsonResponse response) throws Exception {
        switch (request.getMethod()) {
            case GET: {
                GsonUtils.ArrayBuilder roles = GsonUtils.array();
                Set set = request.getAuthenticatedAccount().getRoles();
                GsonUtils.ArrayBuilder arrayBuilder = roles;
                Objects.requireNonNull(arrayBuilder);
                GsonUtils.ArrayBuilder arrayBuilder2 = arrayBuilder;
                set.forEach(xva$0 -> arrayBuilder2.add(new String[]{xva$0}));
                response.setContent(GsonUtils.object().put("authenticated", true).put("roles", roles));
                break;
            }
            case OPTIONS: {
                this.handleOptions((ServiceRequest)request);
                break;
            }
            default: {
                response.setStatusCode(405);
            }
        }
    }
}

