/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.tokens;

import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

record Token(char[] raw, Date expires, String[] roles, Map<String, ? super Object> properties) {
    public static Token fromJWT(DecodedJWT jwt) {
        char[] raw = jwt.getToken().toCharArray();
        Date expires = jwt.getExpiresAt();
        String[] roles = (String[])jwt.getClaim("roles").asArray(String.class);
        HashMap accountProperties = new HashMap();
        jwt.getClaims().entrySet().stream().filter(e -> !((String)e.getKey()).equals("sub")).filter(e -> !((String)e.getKey()).equals("iss")).filter(e -> !((String)e.getKey()).equals("roles")).forEach(e -> accountProperties.put((String)e.getKey(), e.getValue()));
        return new Token(raw, expires, roles, accountProperties);
    }

    public String getDateAsString() {
        return this.expires.toInstant().toString();
    }
}

