/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.authenticators;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.nulabinc.zxcvbn.Feedback;
import com.nulabinc.zxcvbn.Strength;
import com.nulabinc.zxcvbn.Zxcvbn;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.bson.BsonValue;
import org.restheart.configuration.ConfigurationException;
import org.restheart.exchange.MongoRequest;
import org.restheart.exchange.MongoResponse;
import org.restheart.plugins.Inject;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.MongoInterceptor;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.security.authenticators.MongoRealmAuthenticator;
import org.restheart.utils.BsonUtils;
import org.restheart.utils.HttpStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="userPwdStrengthEnforcer", description="enforce strong password for mongoRealmAuthenticator", interceptPoint=InterceptPoint.REQUEST_AFTER_AUTH, enabledByDefault=true, priority=-2147483648)
public class UserPwdStrengthEnforcer
implements MongoInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserPwdStrengthEnforcer.class);
    private static final Zxcvbn zxcvbn = new Zxcvbn();
    private String usersDb;
    private String usersCollection;
    private String propNamePassword;
    private Integer minimumPasswordStrength;
    private boolean enabled = false;
    @Inject(value="registry")
    private PluginsRegistry registry;

    @OnInit
    public void init() {
        PluginRecord _mra;
        try {
            _mra = this.registry.getAuthenticator("mongoRealmAuthenticator");
        }
        catch (ConfigurationException ce) {
            this.enabled = false;
            return;
        }
        if (_mra == null || !_mra.isEnabled()) {
            this.enabled = false;
        } else {
            MongoRealmAuthenticator rhAuth = (MongoRealmAuthenticator)_mra.getInstance();
            if (!rhAuth.isEnforceMinimumPasswordStrength()) {
                this.enabled = false;
                return;
            }
            this.usersDb = rhAuth.getUsersDb();
            this.usersCollection = rhAuth.getUsersCollection();
            this.propNamePassword = rhAuth.getPropPassword();
            this.minimumPasswordStrength = rhAuth.getMinimumPasswordStrength();
            if (this.usersDb == null || this.usersCollection == null || this.propNamePassword == null || this.minimumPasswordStrength == null) {
                LOGGER.error("Wrong configuration of mongoRealmAuthenticator! Password field of users documents is not automatically checked for password strength: {usersDb: {}, usersCollection: {}, propNamePassword: {}, minimumPasswordStrength: {}})", new Object[]{this.usersDb, this.usersCollection, this.propNamePassword, this.minimumPasswordStrength});
                this.enabled = false;
            } else {
                this.enabled = true;
            }
        }
    }

    public void handle(MongoRequest request, MongoResponse response) throws Exception {
        BsonValue content = (BsonValue)request.getContent();
        if (content != null) {
            if (content.isArray() && request.isPost()) {
                JsonArray passwords = (JsonArray)JsonPath.read((String)BsonUtils.toJson((BsonValue)content), (String)"$.[*].".concat(this.propNamePassword), (Predicate[])new Predicate[0]);
                int[] iarr = new int[]{0};
                StreamSupport.stream(Spliterators.spliteratorUnknownSize(passwords.iterator(), 0), false).takeWhile(p -> !response.isInError()).forEach(plain -> {
                    String password;
                    Strength measure;
                    if (plain != null && plain.isJsonPrimitive() && plain.getAsJsonPrimitive().isString() && (measure = zxcvbn.measure((CharSequence)(password = plain.getAsJsonPrimitive().getAsString()))).getScore() < this.minimumPasswordStrength) {
                        this.reject(response, measure.getFeedback(), iarr[0]);
                    }
                    iarr[0] = iarr[0] + 1;
                });
            } else if (content.isDocument()) {
                try {
                    String password;
                    Strength measure;
                    JsonElement plain2 = (JsonElement)JsonPath.read((String)BsonUtils.toJson((BsonValue)content), (String)"$.".concat(this.propNamePassword), (Predicate[])new Predicate[0]);
                    if (plain2 != null && plain2.isJsonPrimitive() && plain2.getAsJsonPrimitive().isString() && (measure = zxcvbn.measure((CharSequence)(password = plain2.getAsJsonPrimitive().getAsString()))).getScore() < this.minimumPasswordStrength) {
                        this.reject(response, measure.getFeedback());
                    }
                }
                catch (PathNotFoundException pathNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    private void reject(MongoResponse response, Feedback feedback) {
        this.reject(response, feedback, null);
    }

    private void reject(MongoResponse response, Feedback feedback, Integer idx) {
        List suggestions;
        BsonUtils.DocumentBuilder error = BsonUtils.document().put("message", (String)(idx == null ? "Password is too weak" : "Password is too weak in user document at index " + idx)).put("http status code", Integer.valueOf(400)).put("http status description", HttpStatus.getStatusText((int)400));
        String warning = feedback.getWarning();
        if (warning != null && !warning.isEmpty()) {
            error.put("warning", warning);
        }
        if ((suggestions = feedback.getSuggestions()) != null && !suggestions.isEmpty()) {
            BsonUtils.ArrayBuilder _suggestions;
            BsonUtils.ArrayBuilder arrayBuilder = _suggestions = BsonUtils.array();
            Objects.requireNonNull(arrayBuilder);
            BsonUtils.ArrayBuilder arrayBuilder2 = arrayBuilder;
            suggestions.forEach(xva$0 -> arrayBuilder2.add(new String[]{xva$0}));
            error.put("suggestions", _suggestions);
        }
        response.setContent(error);
        response.setStatusCode(400);
        response.setInError(true);
    }

    public boolean resolve(MongoRequest request, MongoResponse response) {
        return this.enabled && request.isHandledBy("mongo") && request.isWriteDocument() && request.isContentTypeJson() && this.usersDb.equalsIgnoreCase(request.getDBName()) && this.usersCollection.equalsIgnoreCase(request.getCollectionName());
    }
}

