/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.interceptors;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.undertow.attribute.ExchangeAttributes;
import java.util.Optional;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.restheart.exchange.MongoRequest;
import org.restheart.exchange.MongoResponse;
import org.restheart.plugins.Inject;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.MongoInterceptor;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.security.authenticators.MongoRealmAuthenticator;
import org.restheart.security.authorizers.MongoAclAuthorizer;
import org.restheart.utils.BsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="rootRoleGuard", description="forbids creating or updating mongoRealmAuthenticator accounts with the root-role of the mongoAclAuthorizer", interceptPoint=InterceptPoint.REQUEST_AFTER_AUTH, enabledByDefault=true, priority=11)
public class RootRoleGuard
implements MongoInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RootRoleGuard.class);
    @Inject(value="registry")
    PluginsRegistry registry;
    private boolean enabled = true;
    private String rootRole = null;
    private String usersDb = null;
    private String usersCollection = null;
    private String jsonPathRoles = null;

    @OnInit
    public void init() {
        Optional<MongoRealmAuthenticator> _authenticator = this.registry.getAuthenticators().stream().filter(PluginRecord::isEnabled).map(PluginRecord::getInstance).filter(a -> a instanceof MongoRealmAuthenticator).map(a -> (MongoRealmAuthenticator)a).findFirst();
        Optional<MongoAclAuthorizer> _authorizer = this.registry.getAuthorizers().stream().filter(PluginRecord::isEnabled).map(PluginRecord::getInstance).filter(a -> a instanceof MongoAclAuthorizer).map(a -> (MongoAclAuthorizer)a).findFirst();
        if (_authorizer.isPresent() && _authorizer.get().rootRole() != null && _authenticator.isPresent()) {
            MongoAclAuthorizer authorizer = _authorizer.get();
            MongoRealmAuthenticator authenticator = _authenticator.get();
            this.rootRole = authorizer.rootRole();
            this.usersDb = authenticator.getUsersDb();
            this.usersCollection = authenticator.getUsersCollection();
            this.jsonPathRoles = authenticator.getJsonPathRoles();
        } else {
            this.enabled = false;
        }
    }

    public void handle(MongoRequest request, MongoResponse response) throws Exception {
        BsonDocument doc;
        BsonArray array;
        BsonValue _content = (BsonValue)request.getContent();
        if (_content instanceof BsonArray && this.check(array = (BsonArray)_content)) {
            this.logWarning(request);
            response.setInError(403, "Forbidden. The request has been logged.");
        } else if (_content instanceof BsonDocument && this.check(doc = (BsonDocument)_content)) {
            this.logWarning(request);
            response.setInError(403, "Forbidden. The request has been logged.");
        }
    }

    private void logWarning(MongoRequest request) {
        String clientId = request.isAuthenticated() ? request.getAuthenticatedAccount().getPrincipal().getName() : "unknown";
        String clientRoles = request.isAuthenticated() ? request.getAuthenticatedAccount().getRoles() : "$unauthenticated";
        String remoteIp = ExchangeAttributes.remoteIp().readAttribute(request.getExchange());
        String content = BsonUtils.toJson((BsonValue)((BsonValue)request.getContent()));
        String xff = request.getHeader("X-Forwarded-For");
        LOGGER.warn("{} with roles {} tried to set an account with roles array ({}) containing the root-role ({}). Remote IP={}, X-Forwared-For Header={}, content={}", new Object[]{clientId, clientRoles, this.jsonPathRoles, this.rootRole, remoteIp, xff, content});
    }

    private boolean check(BsonArray array) {
        return array.stream().filter(el -> el.isDocument()).map(el -> el.asDocument()).anyMatch(doc -> this.check((BsonDocument)doc));
    }

    private boolean check(BsonDocument doc) {
        return this.contains(this.roles(doc), this.rootRole);
    }

    private JsonArray roles(BsonDocument doc) {
        try {
            JsonArray array;
            JsonElement account = (JsonElement)JsonPath.read((String)doc.toJson(), (String)"$", (Predicate[])new Predicate[0]);
            Object element = JsonPath.read((Object)account, (String)this.jsonPathRoles, (Predicate[])new Predicate[0]);
            return element instanceof JsonArray ? (array = (JsonArray)element) : new JsonArray();
        }
        catch (Throwable t) {
            return new JsonArray();
        }
    }

    private boolean contains(JsonArray array, String srt) {
        return array.contains((JsonElement)new JsonPrimitive(srt));
    }

    public boolean resolve(MongoRequest request, MongoResponse response) {
        return this.enabled && request.isWriteDocument() && request.getDBName().equals(this.usersDb) && request.getCollectionName().equals(this.usersCollection);
    }
}

