/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.predicates;

import com.google.common.collect.Sets;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.bson.BsonValue;
import org.restheart.exchange.BsonRequest;
import org.restheart.exchange.Request;
import org.restheart.utils.BsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BsonRequestContainsPredicate
implements Predicate {
    private static final Logger LOGGER = LoggerFactory.getLogger(BsonRequestContainsPredicate.class);
    private final Set<String> keys;

    public BsonRequestContainsPredicate(String[] keys) {
        if (keys == null || keys.length < 1) {
            throw new IllegalArgumentException("bson-request-contains predicate must specify a list of json properties");
        }
        this.keys = Sets.newHashSet((Object[])keys);
    }

    public boolean resolve(HttpServerExchange exchange) {
        Request _request = Request.of((HttpServerExchange)exchange);
        if (_request == null || !(_request instanceof BsonRequest)) {
            LOGGER.warn("bson-request-contains predicate not invoked on BsonRequest but {}, it won't allow the request", _request == null ? _request : _request.getClass().getSimpleName());
            return false;
        }
        return BsonUtils.containsKeys((BsonValue)((BsonValue)((BsonRequest)_request).getContent()), this.keys, (boolean)true);
    }

    public static class Builder
    implements PredicateBuilder {
        public String name() {
            return "bson-request-contains";
        }

        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("keys", String[].class);
        }

        public Set<String> requiredParameters() {
            return Collections.singleton("keys");
        }

        public String defaultParameter() {
            return "keys";
        }

        public Predicate build(Map<String, Object> config) {
            return new BsonRequestContainsPredicate((String[])config.get("keys"));
        }
    }
}

