/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.authenticators;

import io.undertow.server.handlers.CookieImpl;
import java.util.Map;
import org.restheart.configuration.Configuration;
import org.restheart.exchange.BsonRequest;
import org.restheart.exchange.BsonResponse;
import org.restheart.exchange.ServiceRequest;
import org.restheart.plugins.BsonService;
import org.restheart.plugins.Inject;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.RegisterPlugin;

@RegisterPlugin(name="authCookieRemover", description="unsets the auth cookie", secure=false, defaultURI="/logout")
public class AuthCookieRemover
implements BsonService {
    @Inject(value="rh-config")
    private Configuration rhConfig;
    private String name;
    private String domain;
    private String path;
    private boolean secure;
    private boolean httpOnly;
    private boolean sameSite;
    private String sameSiteMode;

    @OnInit
    public void init() {
        if (this.rhConfig.toMap().containsKey("authCookieSetter")) {
            Map authCookieSetterConf = (Map)this.rhConfig.toMap().get("authCookieSetter");
            this.name = (String)this.argOrDefault(authCookieSetterConf, "name", "rh_auth");
            this.secure = (Boolean)this.argOrDefault(authCookieSetterConf, "secure", true);
            this.domain = (String)this.argOrDefault(authCookieSetterConf, "domain", "localhost");
            this.path = (String)this.argOrDefault(authCookieSetterConf, "path", "/");
            this.httpOnly = (Boolean)this.argOrDefault(authCookieSetterConf, "http-only", true);
            this.sameSite = (Boolean)this.argOrDefault(authCookieSetterConf, "same-site", true);
            this.sameSiteMode = (String)this.argOrDefault(authCookieSetterConf, "same-site-mode", "strict");
        } else {
            this.name = "rh_auth";
            this.domain = "localhost";
            this.path = "/";
            this.httpOnly = true;
            this.sameSite = true;
            this.sameSiteMode = "strict";
        }
    }

    public void handle(BsonRequest req, BsonResponse res) throws Exception {
        switch (req.getMethod()) {
            case POST: {
                this.unsetAuthTokenCookie(res);
                break;
            }
            case OPTIONS: {
                this.handleOptions((ServiceRequest)req);
                break;
            }
            default: {
                res.setStatusCode(405);
            }
        }
    }

    private void unsetAuthTokenCookie(BsonResponse res) {
        res.getExchange().setResponseCookie(new CookieImpl(this.name, null).setSecure(this.secure).setHttpOnly(this.httpOnly).setDomain(this.domain).setPath(this.path).setSameSite(this.sameSite).setSameSiteMode(this.sameSiteMode));
    }
}

