/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.predicates;

import com.google.common.collect.Sets;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class QParamsBlacklistPredicate
implements Predicate {
    private final Set<String> blacklist;

    public QParamsBlacklistPredicate(String[] blacklist) {
        if (blacklist == null || blacklist.length < 1) {
            throw new IllegalArgumentException("qparams-blacklist predicate must specify a list of query parameters");
        }
        this.blacklist = Sets.newHashSet((Object[])blacklist);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean resolve(HttpServerExchange exchange) {
        Map qparamsInExchange = exchange.getQueryParameters();
        if (qparamsInExchange == null) return true;
        if (!qparamsInExchange.keySet().stream().noneMatch(this.blacklist::contains)) return false;
        return true;
    }

    public static class Builder
    implements PredicateBuilder {
        public String name() {
            return "qparams-blacklist";
        }

        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("blacklist", String[].class);
        }

        public Set<String> requiredParameters() {
            return Collections.singleton("blacklist");
        }

        public String defaultParameter() {
            return "blacklist";
        }

        public Predicate build(Map<String, Object> config) {
            return new QParamsBlacklistPredicate((String[])config.get("blacklist"));
        }
    }
}

