/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.services;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.util.Map;
import org.restheart.configuration.ConfigurationException;
import org.restheart.exchange.JsonRequest;
import org.restheart.exchange.JsonResponse;
import org.restheart.plugins.Inject;
import org.restheart.plugins.JsonService;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.TokenManager;
import org.restheart.security.BaseAccount;

@RegisterPlugin(name="authTokenService", description="allows to get and invalidate the user auth token generated by the active TokenManager", secure=false, enabledByDefault=true, defaultURI="/tokens")
public class AuthTokenService
implements JsonService {
    private static final Escaper ESCAPER = UrlEscapers.urlPathSegmentEscaper();
    @Inject(value="registry")
    private PluginsRegistry registry;
    @Inject(value="config")
    private Map<String, Object> config;

    public void handle(JsonRequest request, JsonResponse response) throws Exception {
        HttpServerExchange exchange = request.getExchange();
        if (request.getPath().startsWith(this.getUri()) && request.getPath().length() >= this.getUri().length() + 2 && Methods.OPTIONS.equals(exchange.getRequestMethod())) {
            response.getHeaders().put(HttpString.tryFromString((String)"Access-Control-Allow-Methods"), "GET, DELETE").put(HttpString.tryFromString((String)"Access-Control-Allow-Headers"), "Accept, Accept-Encoding, Authorization, Content-Length, Content-Type, Host, Origin, X-Requested-With, User-Agent, No-Auth-Challenge");
            response.setStatusCode(200);
            return;
        }
        if (request.getAuthenticatedAccount() == null || request.getAuthenticatedAccount().getPrincipal() == null) {
            response.setStatusCode(401);
            return;
        }
        if (!(this.getUri() + "/" + exchange.getSecurityContext().getAuthenticatedAccount().getPrincipal().getName()).equals(exchange.getRequestURI()) && !ESCAPER.escape(this.getUri() + "/" + exchange.getSecurityContext().getAuthenticatedAccount().getPrincipal().getName()).equals(exchange.getRequestURI())) {
            response.setStatusCode(403);
            return;
        }
        if (Methods.GET.equals(exchange.getRequestMethod())) {
            JsonObject resp = new JsonObject();
            resp.add("auth_token", (JsonElement)new JsonPrimitive(response.getHeader(TokenManager.AUTH_TOKEN_HEADER)));
            resp.add("auth_token_valid_until", (JsonElement)new JsonPrimitive(response.getHeader(TokenManager.AUTH_TOKEN_VALID_HEADER)));
            response.setStatusCode(200);
            response.setContent((Object)resp);
        } else if (Methods.DELETE.equals(exchange.getRequestMethod())) {
            BaseAccount account = new BaseAccount(exchange.getSecurityContext().getAuthenticatedAccount().getPrincipal().getName(), null);
            this.invalidate((Account)account);
            this.removeAuthTokens(exchange);
            response.setStatusCode(204);
        } else {
            response.setStatusCode(405);
        }
    }

    private void invalidate(Account account) {
        PluginRecord tokenManager = this.registry.getTokenManager();
        if (tokenManager == null) {
            throw new IllegalStateException("Error, cannot invalidate, token manager not active");
        }
        ((TokenManager)tokenManager.getInstance()).invalidate(account);
    }

    private void removeAuthTokens(HttpServerExchange exchange) {
        exchange.getResponseHeaders().remove(TokenManager.AUTH_TOKEN_HEADER);
        exchange.getResponseHeaders().remove(TokenManager.AUTH_TOKEN_VALID_HEADER);
        exchange.getResponseHeaders().remove(TokenManager.AUTH_TOKEN_LOCATION_HEADER);
    }

    private String getUri() {
        if (this.config == null) {
            return "/tokens";
        }
        try {
            return (String)this.arg(this.config, "uri");
        }
        catch (ConfigurationException ex) {
            return "/tokens";
        }
    }
}

