/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.authorizers;

import io.undertow.util.PathTemplate;
import io.undertow.util.PathTemplateMatcher;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.restheart.configuration.ConfigurationException;
import org.restheart.exchange.Request;
import org.restheart.plugins.Inject;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.Authorizer;
import org.restheart.utils.URLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="originVetoer", description="protects from CSRF attacks by forbidding requests whose Origin header is not whitelisted", enabledByDefault=false, authorizerType=Authorizer.TYPE.VETOER)
public class OriginVetoer
implements Authorizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OriginVetoer.class);
    private List<String> whitelist = null;
    private List<String> whitelistPatterns = null;
    private PathTemplateMatcher<Boolean> ignoreLists = new PathTemplateMatcher();
    @Inject(value="config")
    private Map<String, Object> config;

    @OnInit
    public void init() {
        try {
            List _whitelist = (List)this.arg(this.config, "whitelist");
            this.whitelist = _whitelist.stream().filter(item -> item != null).map(item -> item.strip()).map(item -> item.toLowerCase()).map(item -> URLUtils.removeTrailingSlashes((String)item)).map(item -> item.concat("/")).collect(Collectors.toList());
            LOGGER.info("whitelist defined for originVetoer, requests will be accepted with Origin header in {}", this.whitelist);
        }
        catch (ConfigurationException ce) {
            this.whitelist = null;
            LOGGER.info("No whitelist defined for originVetoer, all Origin headers are accepted");
        }
        try {
            List _whitelistPatterns = (List)this.arg(this.config, "whitelist-patterns");
            this.whitelistPatterns = _whitelistPatterns.stream().filter(item -> item != null).map(item -> item.strip()).map(item -> item.toLowerCase()).collect(Collectors.toList());
            LOGGER.info("whitelist patterns defined for originVetoer, requests will be accepted with Origin header matching patterns {}", this.whitelistPatterns);
        }
        catch (ConfigurationException ce) {
            this.whitelistPatterns = null;
            LOGGER.info("No whitelist patterns defined for originVetoer");
        }
        try {
            List _ingoreList = (List)this.arg(this.config, "ignore-paths");
            _ingoreList.stream().filter(item -> item != null).map(item -> item.strip()).map(item -> item.toLowerCase()).map(item -> PathTemplate.create((String)item)).forEach(item -> this.ignoreLists.add(item, (Object)true));
            LOGGER.info("ignore list defined for originVetoer, requests will be accepted without checking the Origin header for paths in {}", (Object)_ingoreList);
        }
        catch (ConfigurationException ce) {
            this.ignoreLists = null;
            LOGGER.info("No ignoreLists defined for originVetoer, all paths are checked");
        }
    }

    public boolean isAllowed(Request<?> request) {
        boolean patternMatch;
        boolean exactMatch;
        if (this.ignoreLists != null && this.ignoreLists.match(request.getPath()) != null) {
            LOGGER.debug("originVetoer: request is accepted since path is in ignore list");
            return true;
        }
        if ((this.whitelist == null || this.whitelist.isEmpty()) && (this.whitelistPatterns == null || this.whitelistPatterns.isEmpty())) {
            return true;
        }
        String origin = request.getHeader("Origin");
        if (origin == null) {
            LOGGER.warn("request forbidden by originVetoer due to missing Origin header");
            return false;
        }
        String normalizedOrigin = URLUtils.removeTrailingSlashes((String)origin.toLowerCase()).concat("/");
        if (this.whitelist != null && !this.whitelist.isEmpty() && (exactMatch = this.whitelist.stream().anyMatch(wl -> normalizedOrigin.startsWith((String)wl)))) {
            return true;
        }
        if (this.whitelistPatterns != null && !this.whitelistPatterns.isEmpty() && (patternMatch = this.whitelistPatterns.stream().anyMatch(pattern -> this.matchesPattern(origin, (String)pattern)))) {
            return true;
        }
        LOGGER.warn("request forbidden by originVetoer due to Origin header {} not in whitelist or patterns", (Object)origin);
        return false;
    }

    private boolean matchesPattern(String origin, String pattern) {
        String regex = pattern.replace(".", "\\.").replace("*", ".*");
        try {
            return origin.toLowerCase().matches(regex);
        }
        catch (Exception e) {
            LOGGER.warn("Invalid pattern '{}': {}", (Object)pattern, (Object)e.getMessage());
            return false;
        }
    }

    public boolean isAuthenticationRequired(Request request) {
        return false;
    }
}

