/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.predicates;

import com.google.common.collect.Sets;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.restheart.exchange.BsonRequest;
import org.restheart.exchange.Request;
import org.restheart.utils.BsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BsonRequestWhitelistPredicate
implements Predicate {
    private static final Logger LOGGER = LoggerFactory.getLogger(BsonRequestWhitelistPredicate.class);
    private final Set<String> whitelist;

    public BsonRequestWhitelistPredicate(String[] whitelist) {
        this.whitelist = whitelist == null ? Sets.newHashSet() : Sets.newHashSet((Object[])whitelist);
    }

    public boolean resolve(HttpServerExchange exchange) {
        Request _request = Request.of((HttpServerExchange)exchange);
        if (_request == null || !(_request instanceof BsonRequest)) {
            LOGGER.warn("bson-request-whitelist predicate not invoked on BsonRequest but {}, it won't allow the request", _request == null ? _request : _request.getClass().getSimpleName());
            return false;
        }
        return this.areAllKeysWhitelisted(this.whitelist, (BsonValue)((BsonRequest)_request).getContent());
    }

    private boolean areAllKeysWhitelisted(Set<String> whitelist, BsonValue docArArrayOfDocs) {
        if (docArArrayOfDocs == null) {
            return true;
        }
        if (docArArrayOfDocs.isDocument()) {
            return this.areAllKeysWhitelisted(whitelist, docArArrayOfDocs.asDocument());
        }
        if (docArArrayOfDocs.isArray()) {
            return docArArrayOfDocs.asArray().stream().filter(BsonValue::isDocument).map(BsonValue::asDocument).allMatch(doc -> this.areAllKeysWhitelisted(whitelist, (BsonDocument)doc));
        }
        throw new IllegalArgumentException("bson-request-whitelist predicate cannot be invoked on JSON type " + docArArrayOfDocs.getBsonType().toString());
    }

    private boolean areAllKeysWhitelisted(Set<String> whitelist, BsonDocument doc) {
        if (doc == null || doc.isEmpty()) {
            return true;
        }
        if (whitelist == null || whitelist.isEmpty()) {
            return false;
        }
        return this.getLeafsKeys(doc).stream().allMatch(key -> this.isWhitelisted(whitelist, (String)key));
    }

    private boolean isWhitelisted(Set<String> whitelist, String leafKey) {
        return whitelist.stream().anyMatch(whitelistedKey -> leafKey.equals(whitelistedKey) || leafKey.startsWith(whitelistedKey.concat(".")));
    }

    private Set<String> getLeafsKeys(BsonDocument d) {
        BsonDocument flatten = BsonUtils.flatten((BsonDocument)d, (boolean)true);
        HashSet leafsKeys = Sets.newHashSet();
        leafsKeys.addAll(flatten.keySet());
        d.keySet().stream().filter(BsonUtils::isUpdateOperator).map(uo -> d.get(uo)).filter(doc -> doc.isDocument()).map(doc -> doc.asDocument()).map(doc -> doc.keySet()).forEach(leafsKeys::addAll);
        d.keySet().stream().filter(BsonUtils::isUpdateOperator).forEach(leafsKeys::remove);
        return leafsKeys;
    }

    public static class Builder
    implements PredicateBuilder {
        public String name() {
            return "bson-request-whitelist";
        }

        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("whitelist", String[].class);
        }

        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        public String defaultParameter() {
            return "whitelist";
        }

        public Predicate build(Map<String, Object> config) {
            return new BsonRequestWhitelistPredicate((String[])config.get("whitelist"));
        }
    }
}

