/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security.authorizers;

import org.restheart.exchange.Request;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.security.Authorizer;
import org.restheart.security.authorizers.ACLRegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="aclRegistryVetoer", description="vetoes requests according to veto predicates defined in the ACLRegistry", enabledByDefault=true, authorizerType=Authorizer.TYPE.VETOER)
public class ACLRegistryVetoer
implements Authorizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ACLRegistryVetoer.class);
    private final ACLRegistryImpl registry = ACLRegistryImpl.getInstance();

    public boolean isAllowed(Request<?> request) {
        boolean vetoed = this.registry.vetoPredicates().stream().anyMatch(predicate -> predicate.test(request));
        if (LOGGER.isDebugEnabled() && vetoed) {
            LOGGER.debug("Request vetoed by ACLRegistryVetoer due to a veto predicate");
        }
        return !vetoed;
    }

    public boolean isAuthenticationRequired(Request<?> request) {
        return false;
    }
}

