/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.signup;

import com.google.gson.JsonObject;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import java.util.Deque;
import java.util.Map;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.restheart.exchange.JsonRequest;
import org.restheart.exchange.JsonResponse;
import org.restheart.exchange.ServiceRequest;
import org.restheart.plugins.Inject;
import org.restheart.plugins.JsonService;
import org.restheart.plugins.RegisterPlugin;

@RegisterPlugin(name="userVerifier", description="verifies user", defaultURI="/verify")
public class UserVerifier
implements JsonService {
    @Inject(value="mclient")
    private MongoClient mclient;
    private final String userDb = "restheart";
    private final String usersCollection = "users";
    private final String propId = "_id";
    private final String rolesProperty = "roles";

    public void handle(JsonRequest request, JsonResponse response) throws Exception {
        if (request.isOptions()) {
            this.handleOptions((ServiceRequest)request);
        } else if (request.isGet() && this.checkRequest(request)) {
            Map qparams = request.getQueryParameters();
            if (!qparams.containsKey("username") || ((Deque)qparams.get("username")).isEmpty() || !qparams.containsKey("code") || ((Deque)qparams.get("code")).isEmpty()) {
                JsonObject resp = new JsonObject();
                resp.addProperty("status", "error, missing verification code");
                response.setContent((Object)resp);
                response.setStatusCode(400);
            } else {
                String code;
                String username = (String)((Deque)qparams.get("username")).getFirst();
                if (this.verify(username, code = (String)((Deque)qparams.get("code")).getFirst())) {
                    this.unlock(username);
                    JsonObject resp = new JsonObject();
                    resp.addProperty("status", "verified");
                    response.setContent((Object)resp);
                    response.setStatusCode(200);
                } else {
                    JsonObject resp = new JsonObject();
                    resp.addProperty("status", "error, wrong verification code");
                    response.setContent((Object)resp);
                    response.setStatusCode(403);
                }
            }
        } else {
            response.setStatusCode(501);
        }
    }

    private boolean checkRequest(JsonRequest request) {
        Map qparams = request.getQueryParameters();
        return qparams.containsKey("username") && !((Deque)qparams.get("username")).isEmpty() && qparams.containsKey("code") && !((Deque)qparams.get("code")).isEmpty();
    }

    private boolean verify(String username, String code) {
        MongoCollection coll = this.mclient.getDatabase("restheart").getCollection("users", BsonDocument.class);
        Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)new BsonString(username)), Filters.eq((String)"code", (Object)new BsonString(code)), Filters.eq((String)"roles", (Object)new BsonString("UNVERIFIED"))});
        return coll.find(query).first() != null;
    }

    private void unlock(String username) {
        MongoCollection coll = this.mclient.getDatabase("restheart").getCollection("users", BsonDocument.class);
        BsonArray UNLOCKED_ROLES = new BsonArray();
        UNLOCKED_ROLES.add((BsonValue)new BsonString("USER"));
        coll.findOneAndUpdate(Filters.eq((String)"_id", (Object)new BsonString(username)), Updates.set((String)"roles", (Object)UNLOCKED_ROLES));
    }
}

