/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.signup;

import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.restheart.exchange.MongoRequest;
import org.restheart.exchange.MongoResponse;
import org.restheart.plugins.Inject;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.MongoInterceptor;
import org.restheart.plugins.OnInit;
import org.restheart.plugins.RegisterPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterPlugin(name="emailVerificationSender", description="sends the email to verify email address of registered user", interceptPoint=InterceptPoint.RESPONSE_ASYNC)
public class EmailVerificationSender
implements MongoInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailVerificationSender.class);
    String from;
    String fromName;
    String smptUsername;
    String smtpPassword;
    String host;
    int port;
    String verifierSrvUrl;
    @Inject(value="config")
    private Map<String, Object> config;
    static final String SUBJECT = "RESTHeart Email Verification";
    static final String BODY_TEMPLATE = String.join((CharSequence)System.getProperty("line.separator"), "<h1>Verify your email address</h1>", "<p>Hello from RESTHeart</p>", "<p>To complete the email verification process, click the following link: ", "<a href='${LINK}'>VERIFY</a>");

    @OnInit
    public void init() {
        this.from = (String)this.arg(this.config, "from");
        this.fromName = (String)this.arg(this.config, "from-name");
        this.smptUsername = (String)this.arg(this.config, "smtp-username");
        this.smtpPassword = (String)this.arg(this.config, "smtp-password");
        this.host = (String)this.arg(this.config, "host");
        this.port = (Integer)this.arg(this.config, "port");
        this.verifierSrvUrl = (String)this.arg(this.config, "verifier-srv-url");
    }

    public void handle(MongoRequest request, MongoResponse response) throws Exception {
        String to = response.getDbOperationResult().getNewId().asString().getValue();
        String vcode = response.getDbOperationResult().getNewData().get((Object)"code").asString().getValue();
        this.send(to, vcode);
    }

    public boolean resolve(MongoRequest request, MongoResponse response) {
        return response.getDbOperationResult() != null && response.getDbOperationResult().getNewId() != null && response.getDbOperationResult().getNewId().isString() && response.getDbOperationResult().getNewData() != null && response.getDbOperationResult().getNewData().isDocument() && response.getDbOperationResult().getNewData().asDocument().containsKey((Object)"code") && response.getDbOperationResult().getNewData().asDocument().get((Object)"code").isString();
    }

    private void send(String to, String vcode) throws Exception {
        Properties props = System.getProperties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.port", (Object)this.port);
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.socketFactory.port", (Object)this.port);
        props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(EmailVerificationSender.this.smptUsername, EmailVerificationSender.this.smtpPassword);
            }
        });
        String body = BODY_TEMPLATE.replace("${LINK}", this.verifierSrvUrl.concat("?code=").concat(vcode).concat("&username=").concat(to));
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(this.from, this.fromName));
        msg.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
        msg.setSubject(SUBJECT);
        msg.setContent((Object)body, "text/html");
        try (Transport transport = session.getTransport();){
            LOGGER.debug("Sending verification email to {}", (Object)to);
            transport.connect(this.host, this.smptUsername, this.smtpPassword);
            transport.sendMessage((Message)msg, msg.getAllRecipients());
            LOGGER.debug("Verification email sent to {}", (Object)to);
        }
        catch (Exception ex) {
            LOGGER.warn("Error sending verification email {}", (Object)to, (Object)ex);
        }
    }
}

