/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.signup;

import com.mongodb.client.MongoClient;
import com.mongodb.client.model.Filters;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.restheart.exchange.MongoRequest;
import org.restheart.exchange.MongoResponse;
import org.restheart.plugins.Inject;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.MongoInterceptor;
import org.restheart.plugins.RegisterPlugin;

@RegisterPlugin(name="verificationCodeGenerator", description="adds the verification code and sets the roles to UNVERIFIED whan an unauthenticated client creates a user user document", interceptPoint=InterceptPoint.REQUEST_AFTER_AUTH)
public class VerificationCodeGenerator
implements MongoInterceptor {
    private static final SecureRandom RND_GENERATOR = new SecureRandom();
    @Inject(value="mclient")
    private MongoClient mclient;

    public void handle(MongoRequest request, MongoResponse response) throws Exception {
        if (this.userExists(request)) {
            response.setInError(403, "not authorized");
        } else {
            BsonDocument user = request.getContent().asDocument();
            BsonArray UNLOCKED_ROLES = new BsonArray();
            UNLOCKED_ROLES.add((BsonValue)new BsonString("UNVERIFIED"));
            user.put("code", (BsonValue)this.nextCode());
            user.put("roles", (BsonValue)UNLOCKED_ROLES);
        }
    }

    public boolean resolve(MongoRequest request, MongoResponse response) {
        return this.mclient != null && request.isWriteDocument() && "users".equalsIgnoreCase(request.getCollectionName()) && request.getContent() != null && request.getContent().isDocument() && (request.getAuthenticatedAccount() == null || request.getAuthenticatedAccount().getRoles().contains("$unauthenticated"));
    }

    private boolean userExists(MongoRequest request) {
        if (request.getContent().asDocument().containsKey((Object)"_id")) {
            BsonValue id = request.getContent().asDocument().get((Object)"_id");
            BsonDocument existingUser = (BsonDocument)this.mclient.getDatabase(request.getDBName()).getCollection(request.getCollectionName(), BsonDocument.class).find(Filters.eq((String)"_id", (Object)id)).first();
            return existingUser != null;
        }
        return false;
    }

    private BsonString nextCode() {
        return new BsonString(new BigInteger(256, RND_GENERATOR).toString(36));
    }
}

