/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.common.service;

import java.io.Serializable;
import java.util.List;
import org.resthub.common.service.CrudService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.util.Assert;

public class CrudServiceImpl<T, ID extends Serializable, R extends PagingAndSortingRepository<T, ID>>
implements CrudService<T, ID> {
    protected R repository;

    public void setRepository(R repository) {
        this.repository = repository;
    }

    @Override
    public T create(T resource) {
        Assert.notNull(resource, (String)"Resource can't be null");
        return (T)this.repository.save(resource);
    }

    @Override
    public T update(T resource) {
        Assert.notNull(resource, (String)"Resource can't be null");
        return (T)this.repository.save(resource);
    }

    @Override
    public void delete(T resource) {
        Assert.notNull(resource, (String)"Resource can't be null");
        this.repository.delete(resource);
    }

    @Override
    public void delete(ID id) {
        Assert.notNull(id, (String)"Resource ID can't be null");
        this.repository.delete(id);
    }

    @Override
    public void deleteAll() {
        this.repository.deleteAll();
    }

    @Override
    public void deleteAllWithCascade() {
        Iterable list = this.repository.findAll();
        for (Object entity : list) {
            this.repository.delete(entity);
        }
    }

    @Override
    public T findById(ID id) {
        Assert.notNull(id, (String)"Resource ID can't be null");
        return (T)this.repository.findOne(id);
    }

    @Override
    public List<T> findAll() {
        return (List)this.repository.findAll();
    }

    @Override
    public Page<T> findAll(Pageable pageRequest) {
        return this.repository.findAll(pageRequest);
    }

    @Override
    public Long count() {
        return this.repository.count();
    }
}

