/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.common.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import javax.inject.Named;
import org.resthub.common.util.PostInitialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

@Named(value="postInitializerRunner")
public class PostInitializerRunner
implements ApplicationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostInitializerRunner.class);

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            LOGGER.debug("Scanning for Post Initializers...");
            long startTime = System.currentTimeMillis();
            ContextRefreshedEvent contextRefreshedEvent = (ContextRefreshedEvent)event;
            ApplicationContext applicationContext = contextRefreshedEvent.getApplicationContext();
            Map beans = applicationContext.getBeansOfType(Object.class, false, false);
            LinkedList<PostInitializingMethod> postInitializingMethods = new LinkedList<PostInitializingMethod>();
            for (Object beanNameObject : beans.keySet()) {
                Method[] methods;
                String beanName = (String)beanNameObject;
                Object bean = beans.get(beanNameObject);
                if (bean == null) {
                    LOGGER.warn("Bean name {} return null, so we don't try to get matching bean", (Object)beanName);
                    continue;
                }
                Class<?> beanClass = bean.getClass();
                for (Method method : methods = beanClass.getMethods()) {
                    if (this.getAnnotation(method, PostInitialize.class) == null) continue;
                    if (method.getParameterTypes().length == 0) {
                        int order = this.getAnnotation(method, PostInitialize.class).order();
                        postInitializingMethods.add(new PostInitializingMethod(method, bean, order, beanName));
                        continue;
                    }
                    LOGGER.warn("Post Initializer method can't have any arguments. {} in bean {} won't be invoked", (Object)method.toGenericString(), (Object)beanName);
                }
            }
            Collections.sort(postInitializingMethods);
            long endTime = System.currentTimeMillis();
            LOGGER.debug("Application Context scan completed, took {} ms, {} post initializers found. Invoking now.", (Object)(endTime - startTime), (Object)postInitializingMethods.size());
            for (PostInitializingMethod postInitializingMethod : postInitializingMethods) {
                Method method = postInitializingMethod.getMethod();
                try {
                    method.invoke(postInitializingMethod.getBeanInstance(), new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new BeanCreationException("Post Initialization of bean " + postInitializingMethod.getBeanName() + " failed.", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    throw new BeanCreationException("Post Initialization of bean " + postInitializingMethod.getBeanName() + " failed.", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new BeanCreationException("Post Initialization of bean " + postInitializingMethod.getBeanName() + " failed.", (Throwable)e);
                }
            }
        }
    }

    private <T extends Annotation> T getAnnotation(Method method, Class<T> annotationClass) {
        do {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            return method.getAnnotation(annotationClass);
        } while ((method = this.getSuperMethod(method)) != null);
        return null;
    }

    private Method getSuperMethod(Method method) {
        Class<?> declaring = method.getDeclaringClass();
        if (declaring.getSuperclass() != null) {
            Class<?> superClass = declaring.getSuperclass();
            try {
                Method superMethod = superClass.getMethod(method.getName(), method.getParameterTypes());
                if (superMethod != null) {
                    return superMethod;
                }
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (SecurityException e) {
                return null;
            }
        }
        return null;
    }

    private class PostInitializingMethod
    implements Comparable<PostInitializingMethod> {
        private Method method;
        private Object beanInstance;
        private int order;
        private String beanName;

        private PostInitializingMethod(Method method, Object beanInstance, int order, String beanName) {
            this.method = method;
            this.beanInstance = beanInstance;
            this.order = order;
            this.beanName = beanName;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getBeanInstance() {
            return this.beanInstance;
        }

        public String getBeanName() {
            return this.beanName;
        }

        @Override
        public int compareTo(PostInitializingMethod anotherPostInitializingMethod) {
            int thisVal = this.order;
            int anotherVal = anotherPostInitializingMethod.order;
            return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PostInitializingMethod that = (PostInitializingMethod)o;
            return this.order == that.order && !(this.beanName == null ? that.beanName != null : !this.beanName.equals(that.beanName)) && !(this.method == null ? that.method != null : !this.method.equals(that.method));
        }

        public int hashCode() {
            int result = this.method != null ? this.method.hashCode() : 0;
            result = 31 * result + (this.beanInstance != null ? this.beanInstance.hashCode() : 0);
            result = 31 * result + this.order;
            result = 31 * result + (this.beanName != null ? this.beanName.hashCode() : 0);
            return result;
        }
    }
}

