/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.common.service;

import java.io.Serializable;
import java.util.Set;
import org.resthub.common.service.CrudService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional(readOnly=true)
public class CrudServiceImpl<T, ID extends Serializable, R extends PagingAndSortingRepository<T, ID>>
implements CrudService<T, ID> {
    protected R repository;

    public void setRepository(R repository) {
        this.repository = repository;
    }

    @Override
    @Transactional
    public T create(T resource) {
        Assert.notNull(resource, (String)"Resource can't be null");
        return (T)this.repository.save(resource);
    }

    @Override
    @Transactional
    public T update(T resource) {
        Assert.notNull(resource, (String)"Resource can't be null");
        return (T)this.repository.save(resource);
    }

    @Override
    @Transactional
    public void delete(T resource) {
        Assert.notNull(resource, (String)"Resource can't be null");
        this.repository.delete(resource);
    }

    @Override
    @Transactional
    public void delete(ID id) {
        Assert.notNull(id, (String)"Resource ID can't be null");
        this.repository.delete(id);
    }

    @Override
    @Transactional
    public void deleteAll() {
        this.repository.deleteAll();
    }

    @Override
    @Transactional
    public void deleteAllWithCascade() {
        Iterable list = this.repository.findAll();
        for (Object entity : list) {
            this.repository.delete(entity);
        }
    }

    @Override
    public T findById(ID id) {
        Assert.notNull(id, (String)"Resource ID can't be null");
        return (T)this.repository.findOne(id);
    }

    @Override
    public Iterable<T> findByIds(Set<ID> ids) {
        Assert.notNull(ids, (String)"Resource ids can't be null");
        return this.repository.findAll(ids);
    }

    @Override
    public Iterable<T> findAll() {
        return this.repository.findAll();
    }

    @Override
    public Page<T> findAll(Pageable pageRequest) {
        Assert.notNull((Object)pageRequest, (String)"page request can't be null");
        return this.repository.findAll(pageRequest);
    }

    @Override
    public Long count() {
        return this.repository.count();
    }
}

