/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.jpa;

import java.io.IOException;
import javax.inject.Named;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.ObjectNotFoundException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;

@Named(value="jpaHandlerExceptionResolver")
public class JpaHandlerExceptionResolver
extends AbstractHandlerExceptionResolver {
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        try {
            if (ex instanceof ObjectNotFoundException) {
                return this.handleObjectNotFound((ObjectNotFoundException)ex, request, response, handler);
            }
            if (ex instanceof EntityNotFoundException) {
                return this.handleEntityNotFound((EntityNotFoundException)ex, request, response, handler);
            }
            if (ex instanceof EntityExistsException) {
                return this.handleEntityExists((EntityExistsException)ex, request, response, handler);
            }
        }
        catch (Exception handlerException) {
            this.logger.error((Object)("Handling of [" + ex.getClass().getName() + "] resulted in Exception"), (Throwable)handlerException);
        }
        return null;
    }

    protected ModelAndView handleObjectNotFound(ObjectNotFoundException ex, HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        response.sendError(404);
        return new ModelAndView();
    }

    protected ModelAndView handleEntityNotFound(EntityNotFoundException ex, HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        response.sendError(404);
        return new ModelAndView();
    }

    protected ModelAndView handleEntityExists(EntityExistsException ex, HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        response.sendError(409);
        return new ModelAndView();
    }
}

