/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.jpa;

import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import org.hibernate.ObjectNotFoundException;
import org.resthub.common.model.RestError;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class JpaHandlerExceptionHandler
extends ResponseEntityExceptionHandler {
    @ExceptionHandler(value={ObjectNotFoundException.class, EntityNotFoundException.class, EntityExistsException.class, DataIntegrityViolationException.class})
    public ResponseEntity<Object> handleCustomException(Exception ex, WebRequest request) {
        HttpStatus status;
        HttpHeaders headers = new HttpHeaders();
        if (ex instanceof ObjectNotFoundException) {
            status = HttpStatus.NOT_FOUND;
        } else if (ex instanceof EntityNotFoundException) {
            status = HttpStatus.NOT_FOUND;
        } else if (ex instanceof EntityExistsException) {
            status = HttpStatus.CONFLICT;
        } else if (ex instanceof DataIntegrityViolationException) {
            status = HttpStatus.CONFLICT;
        } else {
            this.logger.warn((Object)("Unknown exception type: " + ex.getClass().getName()));
            HttpStatus status2 = HttpStatus.INTERNAL_SERVER_ERROR;
            return this.handleExceptionInternal(ex, null, headers, status2, request);
        }
        return this.handleExceptionInternal(ex, this.buildRestError(ex, status), headers, status, request);
    }

    private RestError buildRestError(Exception ex, HttpStatus status) {
        RestError.Builder builder = new RestError.Builder();
        builder.setCode(status.value()).setStatus(status.getReasonPhrase()).setThrowable((Throwable)ex);
        return builder.build();
    }
}

