/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.jpa.pool;

import java.util.Properties;
import javax.sql.DataSource;

public abstract class AbstractDataSourceFactory<T extends DataSource> {
    private Class<? extends T> dsClass;

    public DataSource create(Class<? extends T> clazz, Properties dsProperties) throws Exception {
        this.dsClass = clazz;
        return this.create(dsProperties);
    }

    public DataSource create(Properties dsProperties) throws Exception {
        Properties configProperties = new Properties();
        if (dsProperties != null) {
            for (Object o : dsProperties.keySet()) {
                String key = (String)o;
                if (!this.isResolvedProperty(dsProperties, key)) continue;
                configProperties.put(key, dsProperties.get(key));
            }
        }
        return this.instantiateDataSource(configProperties);
    }

    protected boolean isResolvedProperty(Properties dsProperties, String key) {
        return dsProperties.get(key) == null || !(dsProperties.get(key) instanceof String) || !((String)dsProperties.get(key)).startsWith("$");
    }

    protected DataSource callConstructor(Class<? extends T> clazz, Properties configProperties) throws Exception {
        return (DataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    protected DataSource instantiateDataSource(Properties configProperties) throws Exception {
        DataSource dataSource = null;
        if (this.dsClass != null) {
            dataSource = this.callConstructor(this.dsClass, configProperties);
        }
        return dataSource;
    }

    public Class<? extends T> getDsClass() {
        return this.dsClass;
    }

    public void setDsClass(Class<? extends T> dsClass) {
        this.dsClass = dsClass;
    }
}

