/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.test;

import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.resthub.web.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewFilter;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.servlet.DispatcherServlet;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class AbstractWebTest {
    protected int port = 9797;
    protected Boolean startServerOnce = true;
    protected static Server reusableServer;
    protected Server server;
    protected Client client = new Client();
    protected String rootUrl;
    protected String contextLocations = "classpath*:resthubContext.xml classpath*:applicationContext.xml";
    protected String activeProfiles = "";
    protected Boolean annotationBasedConfig = false;
    protected Boolean useOpenEntityManagerInViewFilter = false;
    protected int servletContextHandlerOption = 1;
    protected static final Logger logger;

    public AbstractWebTest() {
    }

    public AbstractWebTest(String activeProfiles) {
        this();
        this.activeProfiles = activeProfiles;
    }

    public AbstractWebTest(int port) {
        this();
        this.port = port;
    }

    public AbstractWebTest(String activeProfiles, int port) {
        this(port);
        this.activeProfiles = activeProfiles;
    }

    protected ServletContextHandler customizeContextHandler(ServletContextHandler context) {
        return context;
    }

    public Client.RequestHolder request(String urlSuffix) {
        return this.client.url("http://localhost:" + this.port + "/" + urlSuffix);
    }

    @BeforeClass
    public void beforeClass() throws Exception {
        if (!this.startServerOnce.booleanValue() || reusableServer == null) {
            this.server = new Server(this.port);
            ServletContextHandler context = new ServletContextHandler(this.servletContextHandlerOption);
            if (this.annotationBasedConfig.booleanValue()) {
                context.getInitParams().put("contextClass", "org.springframework.web.context.support.AnnotationConfigWebApplicationContext");
            }
            context.getInitParams().put("contextConfigLocation", this.contextLocations);
            context.getInitParams().put("spring.profiles.active", this.activeProfiles);
            ServletHolder defaultServletHolder = new ServletHolder(DefaultServlet.class);
            defaultServletHolder.setName("default");
            context.addServlet(defaultServletHolder, "/");
            ServletHolder dispatcherServletHolder = new ServletHolder(DispatcherServlet.class);
            dispatcherServletHolder.setName("dispatcher");
            dispatcherServletHolder.setInitOrder(1);
            dispatcherServletHolder.setInitParameter("contextConfigLocation", "");
            context.addServlet(dispatcherServletHolder, "/");
            context.addEventListener((EventListener)new ContextLoaderListener());
            if (this.useOpenEntityManagerInViewFilter.booleanValue()) {
                context.addFilter(OpenEntityManagerInViewFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
            }
            this.server.setHandler((Handler)context);
            this.server.start();
            if (this.startServerOnce.booleanValue()) {
                reusableServer = this.server;
            }
        }
    }

    @AfterClass
    public void afterClass() {
        if (this.server != null && !this.startServerOnce.booleanValue()) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                logger.error("Error while trying to stop embedded Jetty : " + e);
            }
        }
    }

    static {
        logger = LoggerFactory.getLogger(AbstractWebTest.class);
    }
}

